/* FichothequeLib_API - Copyright (c) 2023-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.exportation.access;

import net.fichotheque.selection.SelectionOptions;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;


/**
 *
 * @author Vincent Calame
 */
public interface AccessDef {

    public final static String PUBLIC_ACCESS = "public";
    public final static String TOKEN_ACCESS = "token";
    public final static String PRIVATE_ACCESS = "private";

    public String getName();

    public Labels getTitleLabels();

    public Attributes getAttributes();

    public String getType();

    public String getToken();

    public default boolean isPublic() {
        return getType().equals(PUBLIC_ACCESS);
    }

    /**
     * Non nul mais peut être de longueur nulle
     *
     * @return
     */
    public String getTableExportName();

    public SelectionOptions getSelectionOptions();

    public static String checkType(String type) {
        switch (type) {
            case PUBLIC_ACCESS:
                return PUBLIC_ACCESS;
            case TOKEN_ACCESS:
                return TOKEN_ACCESS;
            case PRIVATE_ACCESS:
                return PRIVATE_ACCESS;
            default:
                throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

}
