/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.api.interaction.InteractionConstants;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinterUtils;
import net.mapeadores.util.logging.CommandMessage;


/**
 *
 * @author Vincent Calame
 */
public class SubscribeMessageHtmlProducer extends MultiHtmlProducer {

    private final SubscribeResult subscribeResult;
    private final CommandMessage commandMessage;

    public SubscribeMessageHtmlProducer(Multi multi, SubscribeResult subscribeResult, CommandMessage commandMessage) {
        super(multi);
        this.subscribeResult = subscribeResult;
        this.commandMessage = commandMessage;
        addThemeCss("multisubscribe.css");
    }

    public SubscribeMessageHtmlProducer(Multi multi, CommandMessage commandMessage) {
        this(multi, null, commandMessage);
    }

    public SubscribeMessageHtmlProducer(Multi multi, SubscribeResult subscribeResult) {
        this(multi, subscribeResult, null);
    }

    @Override
    public void printHtml() {
        startLoc("_ title.multi.subcribe");
        this
                .MAIN("multisubscribe-Main")
                .__(PageUnit.start("action-Subscribe", "_ title.multi.subcribe"))
                .__(printMessage())
                .__(printTokenWarning())
                .__(printSubscribeLink())
                .__(printFichothequeInfo())
                .__(PageUnit.END)
                ._MAIN();
        end();
    }

    private boolean printMessage() {
        CommandMessage message = getMessage();
        if (message != null) {
            this
                    .__(HtmlPrinterUtils.printCommandMessage(this, message, "multisubscribe-Info", "global-ErrorMessage"));
            return true;
        } else {
            return false;
        }
    }

    private boolean printTokenWarning() {
        CommandMessage message = getMessage();
        if (message == null) {
            return false;
        }
        if ((message.isErrorMessage()) && (message.getMessageKey().contains("token"))) {
            this
                    .P("multisubscribe-TokenWarning")
                    .__localize("_ warning.subscribe.redosubcribe")
                    ._P();
            return true;
        } else {
            return false;
        }
    }

    private boolean printSubscribeLink() {
        if (withFichothequeName()) {
            return false;
        }
        this
                .P("multisubscribe-Link")
                .A(HA.href("multi-subscribe"))
                .__localize("_ link.subscribe.backtosubcribe")
                ._A()
                ._P();
        return true;
    }

    private boolean printFichothequeInfo() {
        if (!withFichothequeName()) {
            return false;
        }
        String relativeUrl = subscribeResult.fichothequeName() + "/session";
        String absoluteUrl = subscribeResult.subscribeParameters().rootUrl() + relativeUrl;
        this
                .P("multisubscribe-Info")
                .__localize("_ submit.subscribe.fichothequesubscribe")
                ._P()
                .P("multisubscribe-Info")
                .__localize("_ label.subscribe.fichothequeurl")
                .__colon()
                ._P()
                .P("multisubscribe-Code")
                .CODE()
                .__escape(absoluteUrl)
                ._CODE()
                ._P()
                .P("multisubscribe-Link")
                .A(HA.href(relativeUrl + "?" + InteractionConstants.BDF_DEFAULT_LOGIN_PARAMNAME + "=" + subscribeResult.login()))
                .__localize("_ link.subscribe.fichotheque")
                ._A()
                ._P();
        return true;
    }

    private CommandMessage getMessage() {
        if (commandMessage != null) {
            return commandMessage;
        }
        if (subscribeResult != null) {
            return subscribeResult.commandMessage();
        }
        return null;
    }

    private boolean withFichothequeName() {
        if (subscribeResult == null) {
            return false;
        }
        return (subscribeResult.fichothequeName() != null);
    }


}
