/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlConstants;
import net.mapeadores.util.request.RequestConstants;


/**
 *
 * @author Vincent Calame
 */
public class AskFormHtmlProducer extends MultiHtmlProducer {

    public AskFormHtmlProducer(Multi multi) {
        super(multi);
        addThemeCss("multisubscribe.css");
    }

    @Override
    public void printHtml() {
        startLoc("_ title.multi.subcribe");
        this
                .MAIN("multisubscribe-Main")
                .__(PageUnit.start("action-Subscribe", "_ title.multi.subcribe"))
                .__(printCommandMessage())
                .__(printForm())
                .__(PageUnit.END)
                ._MAIN();
        end();
    }

    private boolean printForm() {
        this
                .FORM_post("multi-subscribe")
                .INPUT_hidden(RequestConstants.COMMAND_PARAMETER, AskForTokenCommand.COMMAND_NAME)
                .__(Grid.START)
                .__(Grid.textInputRow("_ label.sphere.surname", name(AskForTokenCommand.SURNAME_PARAMNAME).size("30").required(true)))
                .__(Grid.textInputRow("_ label.sphere.forename", name(AskForTokenCommand.FORENAME_PARAMNAME).size("30")))
                .__(printSurnameFirstRow(AskForTokenCommand.SURNAMEFIRST_PARAMNAME, false))
                .__(Grid.inputRow(HtmlConstants.EMAIL_TYPE, "_ label.sphere.email", name(AskForTokenCommand.EMAIL_PARAMNAME).size("30").required(true)))
                .__(Grid.END)
                .__(Button.COMMAND,
                        Button.submit("action-Subscribe", "_ submit.subscribe.sendtoken"))
                ._FORM();
        return true;
    }

    private boolean printSurnameFirstRow(String inputName, boolean checked) {
        String inputId = generateId();
        this
                .__(Grid.START_ROW)
                .__(Grid.START_INPUTCELL)
                .SPAN("command-FlexInput command-Smaller")
                .INPUT_checkbox(HA.name(inputName).value("1").id(inputId).checked(checked))
                .LABEL_for(inputId)
                .__localize("_ label.sphere.surnamefirst")
                ._LABEL()
                ._SPAN()
                .__(Grid.END_INPUTCELL)
                .__(Grid.END_ROW);
        return true;
    }

}
