/* BdfServer_HtmlProducers - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.interaction.Domains;
import fr.exemole.bdfserver.api.interaction.domains.ImportationDomain;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.commands.importation.CorpusImportParseCommand;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlConstants;


/**
 *
 * @author Vincent Calame
 */
public class CorpusImportHtmlProducer extends BdfServerHtmlProducer {

    public CorpusImportHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        addJsLib(BdfJsLibs.DEPLOY);
        addJsLib(BdfJsLibs.APPELANT);
        addJsLib(MiscJsLibs.IMPORTATION);
        addThemeCss("importation.css");
    }

    @Override
    public void printHtml() {
        Map<String, String> storeMap = getStoredValues("form_import_corpus");
        String currentType = getCurrentType(storeMap);
        start();
        printCommandMessageUnit();
        SubsetTree corpusTree = bdfServer.getTreeManager().getSubsetTree(SubsetKey.CATEGORY_CORPUS);
        CommandBox commandBox = CommandBox.init()
                .action(Domains.IMPORTATION)
                .family("CRP")
                .page(ImportationDomain.IMPORTATION_CONFIRM_PAGE)
                .target(HtmlConstants.BLANK_TARGET)
                .multipart(true)
                .name(CorpusImportParseCommand.COMMANDNAME)
                .lockey(CorpusImportParseCommand.COMMANDKEY)
                .submitLocKey("_ submit.importation.parse");
        this
                .__start(commandBox)
                .__(Grid.START)
                .__(Grid.selectRow("_ label.importation.corpus", name(SubsetKey.CATEGORY_CORPUS_STRING).attr("data-subset", "selection"),
                        SubsetTreeOptions.init(corpusTree, bdfServer, workingLang)
                                .onlyNames(true)
                                .selectedSubsetKey(SubsetKey.CATEGORY_CORPUS, storeMap)
                                .withKeys(true))
                )
                .__(Grid.choiceSetRow("_ label.importation.corpusimporttype", () -> {
                    this
                            .__(Grid.radioCell("_ label.importation.corpusimporttype_creation", getTypeRadioAttributes(CorpusRowParser.CREATION_TYPE, currentType),
                                    () -> {
                                        this
                                                .__(Grid.START)
                                                .__(Grid.textInputRow("_ label.importation.defaultowners", name(CorpusImportParseCommand.DEFAULTOWNERS_PARAMNAME).cols(30).value(getDefaultOwners(storeMap)).populate(Appelant.user().sphere(bdfUser))))
                                                .__(Grid.END);
                                    }))
                            .__(Grid.radioCell("_ label.importation.corpusimporttype_change", getTypeRadioAttributes(CorpusRowParser.CHANGE_TYPE, currentType)))
                            .__(Grid.radioCell("_ label.importation.corpusimporttype_remove", getTypeRadioAttributes(CorpusRowParser.REMOVE_TYPE, currentType)));
                }))
                .__(ImportationHtmlUtils.printImportParseRows(this, storeMap))
                .__(Grid.END)
                .__end(commandBox);
        end();
    }

    private HtmlAttributes getTypeRadioAttributes(String type, String current) {
        boolean checked = (type.equals(current));
        return name(CorpusImportParseCommand.TYPE_PARAMNAME).value(type).checked(checked);
    }

    private String getDefaultOwners(Map<String, String> storeMap) {
        String value = storeMap.get(CorpusImportParseCommand.DEFAULTOWNERS_PARAMNAME);
        if (value != null) {
            return value;
        }
        return bdfUser.getRedacteur().getBracketStyle() + ";";
    }

    private static String getCurrentType(Map<String, String> storeMap) {
        String defaultType = CorpusRowParser.CREATION_TYPE;
        String current = storeMap.get(CorpusImportParseCommand.TYPE_PARAMNAME);
        if (current == null) {
            return defaultType;
        } else {
            try {
                return CorpusRowParser.checkType(current);
            } catch (IllegalArgumentException iae) {
                return defaultType;
            }
        }
    }

}
