/* BdfServer_JsonProducers - Copyright (c) 2016-2021 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.json;

import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import java.io.IOException;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LineLog;
import net.mapeadores.util.logging.LineLogs;


/**
 *
 * @author Vincent Calame
 */
public final class BdfCommandResultJson {

    private BdfCommandResultJson() {

    }

    public static void properties(JSONWriter jw, BdfCommandResult bdfCommandResult, MessageLocalisation messageLocalisation) throws IOException {
        CommandMessage commandMessage = bdfCommandResult.getCommandMessage();
        if (commandMessage != null) {
            jw.key("commandMessage");
            CommonJson.object(jw, commandMessage, messageLocalisation);
        }
        Object lineLogsMapObj = bdfCommandResult.getResultObject(BdfInstructionConstants.LINELOGSMAP_OBJ);
        if ((lineLogsMapObj != null) && (lineLogsMapObj instanceof Map)) {
            @SuppressWarnings("unchecked")
            Map<SubsetKey, LineLogs> lineLogsMap = (Map<SubsetKey, LineLogs>) lineLogsMapObj;
            jw.key("lineLogsMap");
            jw.object();
            for (Map.Entry<SubsetKey, LineLogs> entry : lineLogsMap.entrySet()) {
                jw.key(entry.getKey().getKeyString());
                jw.array();
                for (LineLog lineLog : entry.getValue()) {
                    jw.object();
                    CommonJson.properties(jw, lineLog, messageLocalisation);
                    jw.endObject();
                }
                jw.endArray();
            }
            jw.endObject();
        }
    }

}
