/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.scrutari.dataexport.api.BaseMetadataExport;
import net.scrutari.dataexport.api.CorpusMetadataExport;
import net.scrutari.dataexport.api.ExportStateException;
import net.scrutari.dataexport.api.FicheExport;
import net.scrutari.dataexport.api.MotcleExport;
import net.scrutari.dataexport.api.RelationExport;
import net.scrutari.dataexport.api.ScrutariDataExport;
import net.scrutari.dataexport.api.ThesaurusMetadataExport;
import net.scrutari.dataexport.xml.XmlBaseMetadataExport;
import net.scrutari.dataexport.xml.XmlBuilder;
import net.scrutari.dataexport.xml.XmlCorpusMetadataExport;
import net.scrutari.dataexport.xml.XmlFicheExport;
import net.scrutari.dataexport.xml.XmlMotcleExport;
import net.scrutari.dataexport.xml.XmlRelationExport;
import net.scrutari.dataexport.xml.XmlThesaurusMetadataExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlScrutariDataExport
implements ScrutariDataExport {
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String[] RELATIONS_NAMES = new String[]{"default-relation-type", "default-member-type", "default-thesaurus", "default-corpus", "default-role"};
    private final XmlWriter xmlWriter;
    private final XmlFicheExport ficheExport = new XmlFicheExport();
    private final XmlMotcleExport motcleExport = new XmlMotcleExport();
    private final XmlRelationExport relationExport = new XmlRelationExport();
    private final Map<String, Map<String, Integer>> indexationMap = new LinkedHashMap<String, Map<String, Integer>>();
    private final Date date;
    private XmlBuilder xmlBuilder;
    private int currentState = 1;

    public XmlScrutariDataExport(XmlWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.date = null;
    }

    public XmlScrutariDataExport(XmlWriter xmlWriter, Date date) {
        this.xmlWriter = xmlWriter;
        this.date = date;
    }

    @Override
    public BaseMetadataExport startExport() {
        if (this.currentState != 1) {
            throw new ExportStateException(this.currentState, "startExport");
        }
        if (this.date != null) {
            this.xmlWriter.openTagWithAttribute("base", "date", ISO_FORMAT.format(this.date));
        } else {
            this.xmlWriter.openTag("base");
        }
        this.currentState = 2;
        XmlBaseMetadataExport baseMetadataExport = new XmlBaseMetadataExport();
        this.xmlBuilder = baseMetadataExport;
        return baseMetadataExport;
    }

    @Override
    public CorpusMetadataExport newCorpus(String corpusName) {
        this.commonTest("newCorpus");
        this.flushXmlBuilder();
        this.flushFirstLevel();
        this.xmlWriter.openTagWithAttribute("corpus", "corpus-name", corpusName);
        this.currentState = 3;
        XmlCorpusMetadataExport corpusMetadataExport = new XmlCorpusMetadataExport();
        this.xmlBuilder = corpusMetadataExport;
        return corpusMetadataExport;
    }

    @Override
    public FicheExport newFiche(String ficheId) {
        switch (this.currentState) {
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ExportStateException(this.currentState, "newFiche");
            }
        }
        this.flushXmlBuilder();
        this.currentState = 4;
        this.ficheExport.reinit(ficheId);
        this.xmlBuilder = this.ficheExport;
        return this.ficheExport;
    }

    @Override
    public ThesaurusMetadataExport newThesaurus(String thesaurusName) {
        this.commonTest("newThesaurus");
        this.flushXmlBuilder();
        this.flushFirstLevel();
        this.xmlWriter.openTagWithAttribute("thesaurus", "thesaurus-name", thesaurusName);
        this.currentState = 5;
        XmlThesaurusMetadataExport thesaurusMetadataExport = new XmlThesaurusMetadataExport();
        this.xmlBuilder = thesaurusMetadataExport;
        return thesaurusMetadataExport;
    }

    @Override
    public MotcleExport newMotcle(String motcleId) {
        switch (this.currentState) {
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new ExportStateException(this.currentState, "newFiche");
            }
        }
        this.flushXmlBuilder();
        this.currentState = 6;
        this.motcleExport.reinit(motcleId);
        this.xmlBuilder = this.motcleExport;
        return this.motcleExport;
    }

    @Override
    public void addIndexation(String corpusName, String ficheId, String thesaurusName, String motcleId, int weight) {
        this.commonTest("addIndexation");
        if (weight < 1) {
            weight = 1;
        }
        Map<String, Integer> map = this.getIndexationGroupMap(corpusName, thesaurusName);
        String key = ficheId + '\t' + motcleId;
        map.put(key, weight);
    }

    @Override
    public void newRelations(String defaultRelationType, String defaultMemberType, String defaultThesaurus, String defaultCorpus, String defaultRole) {
        String[] values = new String[]{defaultRelationType, defaultMemberType, defaultThesaurus, defaultCorpus, defaultRole};
        this.commonTest("newRelations");
        this.flushXmlBuilder();
        this.flushFirstLevel();
        this.xmlWriter.openTagWithAttributes("relations", RELATIONS_NAMES, values);
        this.currentState = 7;
    }

    @Override
    public RelationExport newRelation(String type) {
        switch (this.currentState) {
            case 7: {
                break;
            }
            default: {
                throw new ExportStateException(this.currentState, "newRelation");
            }
        }
        this.flushXmlBuilder();
        this.relationExport.reinit(type);
        this.xmlBuilder = this.relationExport;
        return this.relationExport;
    }

    @Override
    public void endExport() {
        this.commonTest("endExport");
        this.flushXmlBuilder();
        this.flushFirstLevel();
        this.writeIndexation();
        this.xmlWriter.closeTag("base");
        this.currentState = 99;
    }

    @Override
    public int getState() {
        return this.currentState;
    }

    private void writeIndexation() {
        String[] indexationGroupNameArray = new String[]{"corpus-path", "thesaurus-path"};
        String[] indexationNameArray = new String[]{"fiche-id", "motcle-id", "poids"};
        for (Map.Entry<String, Map<String, Integer>> mapEntry : this.indexationMap.entrySet()) {
            String key = mapEntry.getKey();
            int idx = key.indexOf(9);
            String[] indexationGroupValueArray = new String[]{key.substring(0, idx), key.substring(idx + 1)};
            this.xmlWriter.openTagWithAttributes("indexation-group", indexationGroupNameArray, indexationGroupValueArray);
            Map<String, Integer> map = mapEntry.getValue();
            for (Map.Entry<String, Integer> entry2 : map.entrySet()) {
                String key2 = entry2.getKey();
                int idx2 = key2.indexOf(9);
                String[] indexationValueArray = new String[3];
                indexationValueArray[0] = key2.substring(0, idx2);
                indexationValueArray[1] = key2.substring(idx2 + 1);
                int weight = entry2.getValue();
                String weightString = null;
                if (weight > 1) {
                    weightString = String.valueOf(weight);
                }
                indexationValueArray[2] = weightString;
                this.xmlWriter.addEmptyElement("indexation", indexationNameArray, indexationValueArray);
            }
            this.xmlWriter.closeTag("indexation-group");
        }
    }

    private Map<String, Integer> getIndexationGroupMap(String corpusName, String thesaurusName) {
        String key = corpusName + '\t' + thesaurusName;
        Map<String, Integer> map = this.indexationMap.get(key);
        if (map == null) {
            map = new LinkedHashMap<String, Integer>();
            this.indexationMap.put(key, map);
        }
        return map;
    }

    private void commonTest(String methodName) {
        switch (this.currentState) {
            case 1: 
            case 99: {
                throw new ExportStateException(this.currentState, methodName);
            }
        }
    }

    private void flushXmlBuilder() {
        if (this.xmlBuilder != null) {
            this.xmlBuilder.writeXML(this.xmlWriter);
            this.xmlBuilder = null;
        }
    }

    private void flushFirstLevel() {
        switch (this.currentState) {
            case 3: 
            case 4: {
                this.xmlWriter.closeTag("corpus");
                break;
            }
            case 5: 
            case 6: {
                this.xmlWriter.closeTag("thesaurus");
                break;
            }
            case 7: {
                this.xmlWriter.closeTag("relations");
            }
        }
    }
}

