/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.Locale;

public class QuoteOptions {
    private char openingQuote = (char)171;
    private char closingQuote = (char)187;
    private boolean withNonBreakingSpaces = true;
    public static final QuoteOptions FRENCH_STYLE = new QuoteOptions();
    public static final QuoteOptions ENGLISH_STYLE = new QuoteOptions('\u201c', '\u201d');
    public static final QuoteOptions SPANISH_STYLE = new QuoteOptions('\u00ab', '\u00bb');
    public static final QuoteOptions GERMAN_STYLE = new QuoteOptions('\u00bb', '\u00ab');

    private QuoteOptions() {
    }

    private QuoteOptions(char openQuote, char closeQuote) {
        this.openingQuote = openQuote;
        this.closingQuote = closeQuote;
        this.withNonBreakingSpaces = false;
    }

    public QuoteOptions(char openQuote, char closeQuote, boolean withNonBreakingSpaces) {
        this.openingQuote = openQuote;
        this.closingQuote = closeQuote;
        this.withNonBreakingSpaces = withNonBreakingSpaces;
    }

    public char getOpeningQuote() {
        return this.openingQuote;
    }

    public char getClosingQuote() {
        return this.closingQuote;
    }

    public boolean isWithNonBreakingSpaces() {
        return this.withNonBreakingSpaces;
    }

    public static QuoteOptions getQuoteOptions(Locale locale) {
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("CH")) {
            return SPANISH_STYLE;
        }
        if (lang.equals("fr")) {
            return FRENCH_STYLE;
        }
        if (lang.equals("de")) {
            return GERMAN_STYLE;
        }
        if (lang.equals("es")) {
            return SPANISH_STYLE;
        }
        if (lang.equals("en")) {
            return ENGLISH_STYLE;
        }
        if (lang.equals("pt")) {
            return ENGLISH_STYLE;
        }
        return FRENCH_STYLE;
    }
}

