/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.table;

import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public interface TableWriter {
    public int startRow();

    public int addIntegerCell(Long var1);

    public int addDecimalCell(Decimal var1);

    public int addStringCell(String var1);

    public int addDateCell(FuzzyDate var1);

    public int addMoneyCell(Amount var1);

    public int addPercentageCell(Decimal var1);

    public int endRow();

    default public int addIntegerCell(int integer) {
        return this.addIntegerCell(Long.valueOf(integer));
    }

    default public int addNullCell(short castType) {
        switch (castType) {
            case 1: {
                return this.addIntegerCell(null);
            }
            case 2: {
                return this.addDecimalCell(null);
            }
            case 3: {
                return this.addDateCell(null);
            }
            case 4: {
                return this.addMoneyCell(null);
            }
            case 5: {
                return this.addPercentageCell(null);
            }
        }
        return this.addStringCell(null);
    }

    default public int addCell(short castType, Object obj) {
        if (obj == null) {
            return this.addNullCell(castType);
        }
        switch (castType) {
            case 1: {
                return this.addIntegerCell((Long)obj);
            }
            case 2: {
                return this.addDecimalCell((Decimal)obj);
            }
            case 3: {
                return this.addDateCell((FuzzyDate)obj);
            }
            case 4: {
                return this.addMoneyCell((Amount)obj);
            }
            case 5: {
                return this.addPercentageCell((Decimal)obj);
            }
        }
        return this.addStringCell((String)obj);
    }
}

