/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.GregorianCalendar;
import net.mapeadores.util.primitives.DateUtils;
import net.mapeadores.util.text.DateFormatBundle;

final class FuzzyDateInteger {
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private FuzzyDateInteger() {
    }

    static short getType(int dateInteger) {
        if (FuzzyDateInteger.getDay(dateInteger) != 0) {
            return 5;
        }
        if (FuzzyDateInteger.getMonth(dateInteger) != 0) {
            return 4;
        }
        if (FuzzyDateInteger.getQuarter(dateInteger) != 0) {
            return 3;
        }
        if (FuzzyDateInteger.getHalfYear(dateInteger) != 0) {
            return 2;
        }
        return 1;
    }

    static int getYear(int dateInteger) {
        return (dateInteger & 0xFFFC000) >>> 14;
    }

    static int getHalfYear(int dateInteger) {
        return (dateInteger & 0x3000) >>> 12;
    }

    static int getQuarter(int dateInteger) {
        return (dateInteger & 0xE00) >>> 9;
    }

    static int getMonth(int dateInteger) {
        return (dateInteger & 0x1E0) >>> 5;
    }

    static int getDay(int dateInteger) {
        return dateInteger & 0x1F;
    }

    static int truncate(int dateInteger, short dateType) {
        switch (dateType) {
            case 1: {
                return dateInteger & 0xFFFC000;
            }
            case 2: {
                return dateInteger & 0xFFFF000;
            }
            case 3: {
                return dateInteger & 0xFFFFE00;
            }
            case 4: {
                return dateInteger & 0xFFFFFE0;
            }
        }
        return dateInteger;
    }

    static boolean check(int dateInteger) {
        if (dateInteger == 0) {
            return false;
        }
        if ((dateInteger & 0xF0000000) != 0) {
            return false;
        }
        int year = FuzzyDateInteger.getYear(dateInteger);
        if (year < 1000 && year > 9999) {
            return false;
        }
        if ((dateInteger & 0xFFFF) == 0) {
            return true;
        }
        int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
        if (halfyear == 0 || halfyear == 3) {
            return false;
        }
        int quarter = FuzzyDateInteger.getQuarter(dateInteger);
        if (quarter == 0 || quarter > 4) {
            return false;
        }
        if (halfyear == 1 && quarter > 2) {
            return false;
        }
        if (halfyear == 2 && quarter < 3) {
            return false;
        }
        int month = FuzzyDateInteger.getMonth(dateInteger);
        if (month == 0 || month > 12) {
            return false;
        }
        if (quarter == 1 && month > 3) {
            return false;
        }
        if (quarter == 2 && (month < 4 || month > 6)) {
            return false;
        }
        if (quarter == 3 && (month < 7 || month > 9)) {
            return false;
        }
        if (quarter == 4 && month < 10) {
            return false;
        }
        return FuzzyDateInteger.getDay(dateInteger) != 0;
    }

    static String toString(int dateInteger) {
        StringBuilder buf = new StringBuilder();
        try {
            FuzzyDateInteger.appendString(buf, dateInteger);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    static void appendString(Appendable buf, int dateInteger) throws IOException {
        if (dateInteger < 1) {
            return;
        }
        int year = FuzzyDateInteger.getYear(dateInteger);
        buf.append(String.valueOf(year));
        int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
        if (halfyear == 0) {
            return;
        }
        int quarter = FuzzyDateInteger.getQuarter(dateInteger);
        if (quarter == 0) {
            buf.append("-S");
            buf.append(String.valueOf(halfyear));
            return;
        }
        int month = FuzzyDateInteger.getMonth(dateInteger);
        if (month == 0) {
            buf.append("-T");
            buf.append(String.valueOf(quarter));
            return;
        }
        buf.append('-');
        if (month < 10) {
            buf.append('0');
        }
        buf.append(String.valueOf(month));
        int day = FuzzyDateInteger.getDay(dateInteger);
        if (day == 0) {
            return;
        }
        buf.append('-');
        if (day < 10) {
            buf.append('0');
        }
        buf.append(String.valueOf(day));
    }

    static String toSortString(int dateInteger) {
        if (dateInteger < 1) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            FuzzyDateInteger.appendSortString(dateInteger, buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    private static void appendSortString(int dateInteger, Appendable buf) throws IOException {
        int year = FuzzyDateInteger.getYear(dateInteger);
        buf.append(String.valueOf(year));
        int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
        if (halfyear == 0) {
            return;
        }
        buf.append('S');
        buf.append(String.valueOf(halfyear));
        int quarter = FuzzyDateInteger.getQuarter(dateInteger);
        if (quarter == 0) {
            return;
        }
        buf.append('Q');
        buf.append(String.valueOf(quarter));
        int month = FuzzyDateInteger.getMonth(dateInteger);
        if (month == 0) {
            return;
        }
        if (month < 10) {
            buf.append('0');
        }
        buf.append(String.valueOf(month));
        int day = FuzzyDateInteger.getDay(dateInteger);
        if (day == 0) {
            return;
        }
        if (day < 10) {
            buf.append('0');
        }
        buf.append(String.valueOf(day));
    }

    static int parse(String dateString) throws ParseException {
        if (dateString == null) {
            throw new ParseException("dateString is null", 0);
        }
        int dateLength = dateString.length();
        if (dateLength == 4) {
            int year = FuzzyDateInteger.parseYear(dateString);
            return year << 14;
        }
        if (dateLength == 7) {
            if (dateString.charAt(4) != '-') {
                throw new ParseException("mauvais separateur apres l'annee", 4);
            }
            int year = FuzzyDateInteger.parseYear(dateString);
            int result = year << 14;
            char carac1 = dateString.charAt(5);
            char carac2 = dateString.charAt(6);
            if (carac1 == 'S') {
                if (carac2 == '1' || carac2 == '2') {
                    return result + (carac2 - 48 << 12);
                }
                throw new ParseException("mauvaise valeur de semestre", 6);
            }
            if (carac1 == 'T') {
                return result + FuzzyDateInteger.parseQuarter(carac2);
            }
            if (carac1 == '0') {
                return result + FuzzyDateInteger.parseMonth(carac2, false);
            }
            if (carac1 == '1') {
                return result + FuzzyDateInteger.parseMonth(carac2, true);
            }
            throw new ParseException("mauvaise valeur de mois", 5);
        }
        if (dateLength == 10) {
            if (dateString.charAt(4) != '-') {
                throw new ParseException("mauvais separateur apres l'annee", 4);
            }
            if (dateString.charAt(7) != '-') {
                throw new ParseException("mauvais separateur apres le mois", 7);
            }
            int year = FuzzyDateInteger.parseYear(dateString);
            int result = year << 14;
            char carac1 = dateString.charAt(5);
            char carac2 = dateString.charAt(6);
            if (carac1 == '0') {
                result += FuzzyDateInteger.parseMonth(carac2, false);
            } else if (carac1 == '1') {
                result += FuzzyDateInteger.parseMonth(carac2, true);
            } else {
                throw new ParseException("mauvaise valeur de mois", 5);
            }
            return result + FuzzyDateInteger.parseDay(dateString.charAt(8), dateString.charAt(9));
        }
        throw new ParseException("taille de la chaine incorrecte", dateLength - 1);
    }

    private static int parseQuarter(char carac) throws ParseException {
        int numero = carac - 48;
        if (numero < 1 || numero > 4) {
            throw new ParseException("mauvaise valeur de trimestre", 6);
        }
        int result = numero << 9;
        result = numero < 3 ? (result += 4096) : (result += 8192);
        return result;
    }

    private static int parseMonth(char carac, boolean avecdizaine) throws ParseException {
        int result;
        if (avecdizaine) {
            if (carac < '0' || carac > '2') {
                throw new ParseException("mauvaise valeur de mois", 5);
            }
        } else if (carac < '1' || carac > '9') {
            throw new ParseException("mauvaise valeur de mois", 6);
        }
        int month = carac - 48;
        if (avecdizaine) {
            result = ((month += 10) << 5) + 8192 + 2048;
        } else {
            result = month << 5;
            result = month < 4 ? result + 4096 + 512 : (month < 7 ? result + 4096 + 1024 : result + 8192 + 1536);
        }
        return result;
    }

    private static int parseDay(char carac1, char carac2) throws ParseException {
        if (carac1 < '0' || carac1 > '3') {
            throw new ParseException("mauvaise valeur de jour", 8);
        }
        if (carac2 < '0' || carac2 > '9') {
            throw new ParseException("mauvaise valeur de jour", 9);
        }
        return carac2 - 48 + (carac1 - 48) * 10;
    }

    private static int parseYear(String chaine) throws ParseException {
        int year = 0;
        for (int i = 0; i < 4; ++i) {
            char carac = chaine.charAt(i);
            if (carac < '0' || carac > '9') {
                throw new ParseException("mauvais caractere dans l'annee", i);
            }
            if (i == 0 && carac == '0') {
                throw new ParseException("annee inferieure a 1000", i);
            }
            year += (int)Math.pow(10.0, 3 - i) * (carac - 48);
        }
        return year;
    }

    static int fromYear(int year) {
        if (year < 1000 || year > 9999) {
            throw new IllegalArgumentException("wrong year");
        }
        return year << 14;
    }

    static int fromHalfYear(int year, int halfyear) {
        if (year < 1000 || year > 9999) {
            throw new IllegalArgumentException("wrong year");
        }
        if (halfyear < 1 || halfyear > 2) {
            throw new IllegalArgumentException("wrong half year");
        }
        int result = (year << 14) + (halfyear << 12);
        return result;
    }

    static int fromQuarter(int year, int quarter) {
        if (year < 1000 || year > 9999) {
            throw new IllegalArgumentException("wrong year");
        }
        if (quarter < 1 || quarter > 4) {
            throw new IllegalArgumentException("wrong quarter");
        }
        int result = (year << 14) + (quarter << 9);
        result = quarter < 3 ? (result += 4096) : (result += 8192);
        return result;
    }

    static int fromMonth(int year, int month) {
        if (year < 1000 || year > 9999) {
            throw new IllegalArgumentException("wrong year");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("wrong month");
        }
        return FuzzyDateInteger.fromInt(year, month, -1);
    }

    static int fromDay(int year, int month, int day) {
        if (year < 1000 || year > 9999) {
            throw new IllegalArgumentException("wrong year");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("wrong month");
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("wrong day");
        }
        return FuzzyDateInteger.fromInt(year, month, day);
    }

    private static int fromInt(int year, int month, int day) {
        int result = year << 14;
        result += month << 5;
        if (day != -1) {
            result += day;
        }
        result = month < 4 ? result + 4096 + 512 : (month < 7 ? result + 4096 + 1024 : (month < 10 ? result + 8192 + 1536 : result + 8192 + 2048));
        return result;
    }

    static GregorianCalendar toGregorianCalendar(int dateInteger) {
        GregorianCalendar gc = new GregorianCalendar();
        int year = FuzzyDateInteger.getYear(dateInteger);
        short type = FuzzyDateInteger.getType(dateInteger);
        int month = 1;
        int day = 1;
        switch (type) {
            case 2: {
                int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
                if (halfyear != 2) break;
                month = 7;
                break;
            }
            case 3: {
                int quarter = FuzzyDateInteger.getQuarter(dateInteger);
                if (quarter == 2) {
                    month = 4;
                    break;
                }
                if (quarter == 3) {
                    month = 7;
                    break;
                }
                if (quarter != 4) break;
                month = 10;
                break;
            }
            case 4: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                break;
            }
            case 5: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                day = FuzzyDateInteger.getDay(dateInteger);
            }
        }
        gc.set(year, month - 1, day);
        return gc;
    }

    static String toISOString(int dateInteger, boolean lastDate) {
        StringBuilder buf = new StringBuilder();
        try {
            FuzzyDateInteger.appendCompleteString(buf, dateInteger, true, lastDate);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    static String toMonthString(int dateInteger, boolean lastMonth) {
        StringBuilder buf = new StringBuilder();
        try {
            FuzzyDateInteger.appendCompleteString(buf, dateInteger, false, lastMonth);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    static void appendCompleteString(Appendable buf, int dateInteger, boolean withDay, boolean lastDate) throws IOException {
        int year = FuzzyDateInteger.getYear(dateInteger);
        buf.append(String.valueOf(year));
        buf.append('-');
        short type = FuzzyDateInteger.getType(dateInteger);
        int month = lastDate ? 12 : 1;
        int day = -1;
        switch (type) {
            case 2: {
                int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
                if (lastDate) {
                    if (halfyear != 1) break;
                    month = 6;
                    break;
                }
                if (halfyear != 2) break;
                month = 7;
                break;
            }
            case 3: {
                int quarter = FuzzyDateInteger.getQuarter(dateInteger);
                if (lastDate) {
                    if (quarter == 1) {
                        month = 3;
                        break;
                    }
                    if (quarter == 2) {
                        month = 6;
                        break;
                    }
                    if (quarter != 3) break;
                    month = 9;
                    break;
                }
                if (quarter == 2) {
                    month = 4;
                    break;
                }
                if (quarter == 3) {
                    month = 7;
                    break;
                }
                if (quarter != 4) break;
                month = 10;
                break;
            }
            case 4: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                break;
            }
            case 5: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                if (!withDay) break;
                day = FuzzyDateInteger.getDay(dateInteger);
            }
        }
        if (month < 10) {
            buf.append("0");
        }
        buf.append(String.valueOf(month));
        if (withDay) {
            if (day == -1) {
                day = lastDate ? DateUtils.getLastDayOfMonth(month, year) : 1;
            }
            buf.append("-");
            if (day < 10) {
                buf.append("0");
            }
            buf.append(String.valueOf(day));
        }
    }

    static LocalDate toLocaleDate(int dateInteger, boolean lastDate) {
        int year = FuzzyDateInteger.getYear(dateInteger);
        short type = FuzzyDateInteger.getType(dateInteger);
        int month = lastDate ? 12 : 1;
        int day = -1;
        switch (type) {
            case 2: {
                int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
                if (lastDate) {
                    if (halfyear != 1) break;
                    month = 6;
                    break;
                }
                if (halfyear != 2) break;
                month = 7;
                break;
            }
            case 3: {
                int quarter = FuzzyDateInteger.getQuarter(dateInteger);
                if (lastDate) {
                    if (quarter == 1) {
                        month = 3;
                        break;
                    }
                    if (quarter == 2) {
                        month = 6;
                        break;
                    }
                    if (quarter != 3) break;
                    month = 9;
                    break;
                }
                if (quarter == 2) {
                    month = 4;
                    break;
                }
                if (quarter == 3) {
                    month = 7;
                    break;
                }
                if (quarter != 4) break;
                month = 10;
                break;
            }
            case 4: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                break;
            }
            case 5: {
                month = FuzzyDateInteger.getMonth(dateInteger);
                day = FuzzyDateInteger.getDay(dateInteger);
            }
        }
        if (day == -1) {
            day = lastDate ? DateUtils.getLastDayOfMonth(month, year) : 1;
        }
        return LocalDate.of(year, month, day);
    }

    static int fromGregorianCalendar(GregorianCalendar gregcalendar) {
        return FuzzyDateInteger.fromInt(gregcalendar.get(1), gregcalendar.get(2) + 1, gregcalendar.get(5));
    }

    static int fromDate(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return FuzzyDateInteger.fromGregorianCalendar(gc);
    }

    static Date toDate(int dateInteger) {
        return FuzzyDateInteger.toGregorianCalendar(dateInteger).getTime();
    }

    static int current() {
        return FuzzyDateInteger.fromGregorianCalendar(new GregorianCalendar());
    }

    static String getDateLitteral(int dateInteger, DateFormatBundle dateFormatBundle) {
        short type = FuzzyDateInteger.getType(dateInteger);
        DateFormat dateformat = null;
        switch (type) {
            case 5: {
                dateformat = dateFormatBundle.getFormatJour();
                break;
            }
            case 4: {
                dateformat = dateFormatBundle.getFormatMois();
                break;
            }
            case 1: {
                dateformat = dateFormatBundle.getFormatAnnee();
                break;
            }
            case 2: {
                int halfyear = FuzzyDateInteger.getHalfYear(dateInteger);
                return dateFormatBundle.getLocalizedString("s" + String.valueOf(halfyear)) + " " + String.valueOf(FuzzyDateInteger.getYear(dateInteger));
            }
            case 3: {
                int quarter = FuzzyDateInteger.getQuarter(dateInteger);
                return dateFormatBundle.getLocalizedString("t" + String.valueOf(quarter)) + " " + String.valueOf(FuzzyDateInteger.getYear(dateInteger));
            }
        }
        if (dateformat != null) {
            return dateformat.format(FuzzyDateInteger.toDate(dateInteger));
        }
        return FuzzyDateInteger.toString(dateInteger);
    }

    static int parse(String s, DateFormatBundle dateFormatBundle) throws ParseException {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("datation string is null");
        }
        try {
            int dateInteger = FuzzyDateInteger.parse(s);
            return dateInteger;
        }
        catch (ParseException dee) {
            int idx;
            if (dateFormatBundle != null) {
                try {
                    Date date = dateFormatBundle.getParseFormat().parse(s);
                    return FuzzyDateInteger.fromDate(date);
                }
                catch (ParseException date) {
                    // empty catch block
                }
            }
            if ((idx = s.indexOf(47)) > 0) {
                Date date = ISO_FORMAT.parse(s.substring(idx + 1) + "-" + s.substring(0, idx) + "-01");
                int dateInteger = FuzzyDateInteger.fromDate(date);
                return FuzzyDateInteger.truncate(dateInteger, (short)4);
            }
            throw new ParseException("unable to parse", 0);
        }
    }

    static int roll(int dateInteger, int dayAmount) {
        if (dayAmount == 0) {
            return dateInteger;
        }
        if (dayAmount < 0) {
            return FuzzyDateInteger.rollToPast(dateInteger, -dayAmount);
        }
        return FuzzyDateInteger.rollToFuture(dateInteger, dayAmount);
    }

    private static int rollToPast(int dateInteger, int amount) {
        GregorianCalendar cal = FuzzyDateInteger.toGregorianCalendar(dateInteger);
        int dayOfYear = cal.get(6);
        if (dayOfYear - amount > 0) {
            cal.roll(6, -amount);
            return FuzzyDateInteger.fromGregorianCalendar(cal);
        }
        int newDateInteger = FuzzyDateInteger.fromInt(FuzzyDateInteger.getYear(dateInteger) - 1, 12, 31);
        if ((amount -= dayOfYear) == 0) {
            return newDateInteger;
        }
        return FuzzyDateInteger.rollToPast(newDateInteger, amount);
    }

    private static int rollToFuture(int dateInteger, int amount) {
        GregorianCalendar cal = FuzzyDateInteger.toGregorianCalendar(dateInteger);
        int dayOfYear = cal.get(6);
        int yearLength = 365;
        if (cal.isLeapYear(cal.get(1))) {
            yearLength = 366;
        }
        if (amount + dayOfYear <= yearLength) {
            cal.roll(6, amount);
            return FuzzyDateInteger.fromGregorianCalendar(cal);
        }
        amount = amount + dayOfYear - yearLength - 1;
        int newDateInteger = FuzzyDateInteger.fromInt(FuzzyDateInteger.getYear(dateInteger) + 1, 1, 1);
        if (amount == 0) {
            return newDateInteger;
        }
        return FuzzyDateInteger.rollToFuture(newDateInteger, amount);
    }
}

