/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public final class LangsUtils {
    public static final Langs EMPTY_LANGS = new EmptyLangs();
    public static final List<Lang> EMPTY_LANGLIST = Collections.emptyList();

    private LangsUtils() {
    }

    public static Langs toCleanLangs(String s) {
        Lang[] array = LangsUtils.toCleanLangArray(s);
        return new ArrayLangs(array);
    }

    public static Lang[] toCleanLangArray(String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, true);
        LinkedHashSet<Lang> langSet = new LinkedHashSet<Lang>();
        for (String token : tokens) {
            try {
                Lang lang = Lang.parse(token);
                langSet.add(lang);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return langSet.toArray(new Lang[langSet.size()]);
    }

    public static Langs fromCollection(Collection<Lang> collection) {
        Lang[] array = collection.toArray(new Lang[collection.size()]);
        return new ArrayLangs(array);
    }

    public static boolean areEquals(Langs langs, Lang[] array) {
        int length = array.length;
        if (length != langs.size()) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i].equals(langs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquals(Langs langs, Collection<Lang> collection) {
        int length = collection.size();
        if (length != langs.size()) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        int p = 0;
        for (Lang lang : collection) {
            if (!lang.equals(langs.get(p))) {
                return false;
            }
            ++p;
        }
        return true;
    }

    public static boolean areEquals(Langs langs1, Langs langs2) {
        int length = langs2.size();
        if (length != langs1.size()) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (((Lang)langs2.get(i)).equals(langs1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Lang getNearestLang(Langs langs, Lang lang) {
        if (langs.isEmpty()) {
            throw new IllegalArgumentException("langs.isEmpty()");
        }
        Lang option1 = null;
        Lang option2 = null;
        Lang rootLang = lang.getRootLang();
        for (Lang testedLang : langs) {
            if (testedLang.equals(lang)) {
                return testedLang;
            }
            if (testedLang.equals(rootLang)) {
                option1 = testedLang;
                continue;
            }
            if (!testedLang.getRootLang().equals(rootLang)) continue;
            option2 = testedLang;
        }
        if (option1 != null) {
            return option1;
        }
        if (option2 != null) {
            return option2;
        }
        return (Lang)langs.get(0);
    }

    public static Langs merge(Langs ... langs) {
        if (langs == null) {
            return EMPTY_LANGS;
        }
        LinkedHashSet<Lang> set = new LinkedHashSet<Lang>();
        for (Langs lgs : langs) {
            if (lgs == null) continue;
            for (Lang lang : lgs) {
                set.add(lang);
            }
        }
        return LangsUtils.wrap(set);
    }

    public static Langs wrap(Collection<Lang> langs) {
        int size = langs.size();
        if (size == 0) {
            return EMPTY_LANGS;
        }
        return new ArrayLangs(langs.toArray(new Lang[size]));
    }

    public static Langs wrap(Lang ... langs) {
        if (langs == null || langs.length == 0) {
            return EMPTY_LANGS;
        }
        return new ArrayLangs(langs);
    }

    public static Lang[] toArray(Langs langs) {
        return langs.toArray(new Lang[langs.size()]);
    }

    public static Lang checkLang(Lang userLang, List<Lang> authorizedLangs) {
        Lang option1 = null;
        Lang option2 = null;
        Lang rootLang = userLang.getRootLang();
        for (Lang authorizedLang : authorizedLangs) {
            if (authorizedLang.equals(userLang)) {
                return authorizedLang;
            }
            if (authorizedLang.equals(rootLang)) {
                option1 = authorizedLang;
                continue;
            }
            if (!authorizedLang.getRootLang().equals(rootLang)) continue;
            option2 = authorizedLang;
        }
        if (option1 != null) {
            return option1;
        }
        if (option2 != null) {
            return option2;
        }
        return null;
    }

    public static void readLangElements(Collection<Lang> destination, Element parentElement, MessageHandler messageHandler, String xpath) {
        DOMUtils.readChildren(parentElement, new LangConsumer(destination, messageHandler, xpath));
    }

    public static void readLangElements(LangPreferenceBuilder langPreferenceBuilder, Element parentElement, MessageHandler messageHandler, String xpath) {
        DOMUtils.readChildren(parentElement, new LangPreferenceConsumer(langPreferenceBuilder, messageHandler, xpath));
    }

    public static Lang getPreferredAvailableLang(Langs availableLangs, LangPreference langPreference) {
        if (availableLangs.isEmpty()) {
            throw new IllegalArgumentException("availableLangs is empty");
        }
        HashSet<Lang> currentSet = new HashSet<Lang>(availableLangs);
        for (Lang lang : langPreference) {
            if (currentSet.contains(lang)) {
                return lang;
            }
            if (lang.isRootLang() || !currentSet.contains(lang.getRootLang())) continue;
            return lang.getRootLang();
        }
        return (Lang)availableLangs.get(0);
    }

    private static class ArrayLangs
    extends AbstractList<Lang>
    implements Langs {
        private final Lang[] array;

        private ArrayLangs(Lang[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Lang get(int i) {
            return this.array[i];
        }
    }

    private static class LangConsumer
    implements Consumer<Element> {
        private final Collection<Lang> langs;
        private final MessageHandler messageHandler;
        private final String xpath;

        private LangConsumer(Collection<Lang> langs, MessageHandler messageHandler, String xpath) {
            this.langs = langs;
            this.messageHandler = messageHandler;
            this.xpath = xpath;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String tagPath = this.xpath + "/" + tagName;
            if (tagName.equals("lang")) {
                String text = XMLUtils.getData(element);
                try {
                    Lang lang = Lang.parse(text);
                    this.langs.add(lang);
                }
                catch (ParseException pe) {
                    DomMessages.wrongElementValue(this.messageHandler, tagPath, text);
                }
            } else {
                DomMessages.unknownTagWarning(this.messageHandler, tagPath);
            }
        }
    }

    private static class LangPreferenceConsumer
    implements Consumer<Element> {
        private final LangPreferenceBuilder langPreferenceBuilder;
        private final MessageHandler messageHandler;
        private final String xpath;

        private LangPreferenceConsumer(LangPreferenceBuilder langPreferenceBuilder, MessageHandler messageHandler, String xpath) {
            this.langPreferenceBuilder = langPreferenceBuilder;
            this.messageHandler = messageHandler;
            this.xpath = xpath;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String tagPath = this.xpath + "/" + tagName;
            if (tagName.equals("lang")) {
                String text = XMLUtils.getData(element);
                try {
                    Lang lang = Lang.parse(text);
                    this.langPreferenceBuilder.addLang(lang);
                }
                catch (ParseException pe) {
                    DomMessages.wrongElementValue(this.messageHandler, tagPath, text);
                }
            } else {
                DomMessages.unknownTagWarning(this.messageHandler, tagPath);
            }
        }
    }

    private static class EmptyLangs
    extends AbstractList<Lang>
    implements Langs {
        private EmptyLangs() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Lang get(int i) {
            throw new IndexOutOfBoundsException("langCount = 0");
        }
    }
}

