/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.text.DecimalFormatSymbols;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;

public class HtmlTableWriter
implements TableWriter {
    private final HtmlPrinter hp;
    private final DecimalFormatSymbols symbols;
    private int rowNumber;
    private int columnNumber;

    public HtmlTableWriter(HtmlPrinter hp, DecimalFormatSymbols symbols) {
        this.hp = hp;
        this.symbols = symbols;
        this.rowNumber = 0;
    }

    @Override
    public int startRow() {
        ++this.rowNumber;
        this.hp.TR();
        this.columnNumber = 0;
        return this.rowNumber;
    }

    @Override
    public int addIntegerCell(Long lg) {
        ++this.columnNumber;
        if (lg == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__append(lg)._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addDecimalCell(Decimal decimal) {
        ++this.columnNumber;
        if (decimal == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape(decimal)._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addStringCell(String s) {
        ++this.columnNumber;
        if (s == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__(HtmlTableWriter.printStringValue(this.hp, s))._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addDateCell(FuzzyDate date) {
        ++this.columnNumber;
        if (date == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape(date.toISOString())._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addMoneyCell(Amount amount) {
        ++this.columnNumber;
        if (amount == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape(amount.toLitteralString(this.symbols, false))._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int addPercentageCell(Decimal decimal) {
        ++this.columnNumber;
        if (decimal == null) {
            this.hp.TD()._TD();
        } else {
            this.hp.TD().__escape(decimal)._TD();
        }
        return this.columnNumber;
    }

    @Override
    public int endRow() {
        this.hp._TR();
        return this.rowNumber;
    }

    public static boolean printStringValue(HtmlPrinter hp, String s) {
        int length = s.length();
        block4: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\r': {
                    if (i < length - 1 && s.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    hp.BR();
                    continue block4;
                }
                default: {
                    hp.__escape(carac);
                }
            }
        }
        return true;
    }
}

