/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.StringUtils;

public final class AttributeParser {
    private AttributeParser() {
    }

    public static String toString(Attributes attributes) {
        return AttributeParser.toString(attributes, "=", ";");
    }

    public static String toString(Attributes attributes, String keySeparator, String separator) {
        StringBuilder buf = new StringBuilder();
        int attributeLength = attributes.size();
        for (int i = 0; i < attributeLength; ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(attribute.getAttributeKey().toString());
            buf.append(keySeparator);
            int valueLength = attribute.size();
            for (int j = 0; j < valueLength; ++j) {
                if (j > 0) {
                    buf.append(separator);
                }
                String value = (String)attribute.get(j);
                int length = value.length();
                for (int k = 0; k < length; ++k) {
                    char carac = value.charAt(k);
                    switch (carac) {
                        case ';': 
                        case '\\': {
                            buf.append('\\');
                        }
                    }
                    buf.append(carac);
                }
            }
        }
        return buf.toString();
    }

    public static AttributeChange parse(String text) {
        AttributeChangeBuilder attributeChangeBuilder = new AttributeChangeBuilder();
        AttributeParser.parse(attributeChangeBuilder, text);
        return attributeChangeBuilder.toAttributeChange();
    }

    public static void parse(AttributeChangeBuilder attributeChangeBuilder, String text) {
        String[] tokens;
        for (String token : tokens = StringUtils.getLineTokens(text, (short)2)) {
            int idx = token.indexOf(61);
            if (idx < 1) continue;
            String key = token.substring(0, idx);
            String values = token.substring(idx + 1);
            try {
                AttributeKey attributeKey = AttributeKey.parse(key);
                List<CleanedString> valueList = AttributeParser.parseValues(values);
                if (valueList.isEmpty()) {
                    attributeChangeBuilder.putRemovedAttributeKey(attributeKey);
                    continue;
                }
                attributeChangeBuilder.appendValues(attributeKey, valueList);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static List<CleanedString> parseValues(String values) {
        ArrayList<CleanedString> resultList = new ArrayList<CleanedString>();
        AttributeParser.parseValues(resultList, values);
        return resultList;
    }

    public static void parseValues(List<CleanedString> valueList, String values) {
        CleanedString cs;
        if (values == null) {
            return;
        }
        int length = values.length();
        if (length == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        boolean ignoreNext = false;
        for (int i = 0; i < length; ++i) {
            char carac = values.charAt(i);
            if (ignoreNext) {
                ignoreNext = false;
                buf.append(carac);
                continue;
            }
            if (carac == '\\') {
                ignoreNext = true;
                continue;
            }
            if (carac == ';') {
                if (buf.length() <= 0) continue;
                CleanedString cs2 = CleanedString.newInstance(buf.toString());
                if (cs2 != null) {
                    valueList.add(cs2);
                }
                buf = new StringBuilder();
                continue;
            }
            buf.append(carac);
        }
        if (buf.length() > 0 && (cs = CleanedString.newInstance(buf.toString())) != null) {
            valueList.add(cs);
        }
    }
}

