/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.extraction.DataResolver;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.filterunit.AddendaExtractFilterUnit;
import net.fichotheque.extraction.filterunit.AlbumExtractFilterUnit;
import net.fichotheque.extraction.filterunit.BodyFilterUnit;
import net.fichotheque.extraction.filterunit.ChronoFilterUnit;
import net.fichotheque.extraction.filterunit.CorpusExtractFilterUnit;
import net.fichotheque.extraction.filterunit.DataFilterUnit;
import net.fichotheque.extraction.filterunit.FicheParentageFilterUnit;
import net.fichotheque.extraction.filterunit.FieldKeyFilterUnit;
import net.fichotheque.extraction.filterunit.FieldNamePrefixFilterUnit;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.filterunit.HeadFilterUnit;
import net.fichotheque.extraction.filterunit.LotFilterUnit;
import net.fichotheque.extraction.filterunit.MasterMotcleFilterUnit;
import net.fichotheque.extraction.filterunit.PhraseFilterUnit;
import net.fichotheque.extraction.filterunit.ThesaurusExtractFilterUnit;
import net.fichotheque.extraction.run.AddendaExtractor;
import net.fichotheque.extraction.run.AlbumExtractor;
import net.fichotheque.extraction.run.CorpusExtractor;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.ThesaurusExtractor;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.selection.DocumentSelector;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.IllustrationSelector;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.DocumentSelectorBuilder;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.IllustrationSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.fichotheque.xml.extraction.AddendaExtractXMLPart;
import net.fichotheque.xml.extraction.AlbumExtractXMLPart;
import net.fichotheque.xml.extraction.CorpusExtractXMLPart;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.FicheBlockXMLPart;
import net.fichotheque.xml.extraction.FicheItemXMLPart;
import net.fichotheque.xml.extraction.FieldNameInfo;
import net.fichotheque.xml.extraction.MotcleXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.fichotheque.xml.extraction.ThesaurusExtractXMLPart;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.alphabet.AlphabeticEntry;
import net.mapeadores.util.xml.FillControllerXMLPart;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class FicheXMLPart
extends XMLPart {
    private final FilterUnitXMLPart filterUnitPart;
    private final TagNames tagNames;
    private FicheFilter ficheFilter;
    private FichePointeur fichePointeur;

    public FicheXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.tagNames = new TagNames(extractParameters.getExtractVersion());
        this.filterUnitPart = new FilterUnitXMLPart(xmlWriter, extractParameters, this.tagNames);
    }

    public void addFiche(FicheExtractInfo ficheExtractInfo) throws IOException {
        this.updatePointeur(ficheExtractInfo);
        this.ficheFilter = ficheExtractInfo.getFicheFilter();
        FicheMeta ficheMeta = ficheExtractInfo.getFicheMeta();
        Croisement croisement = ficheExtractInfo.getCroisement();
        String tagName = this.getTagName(this.ficheFilter.getTagNameInfo());
        if (tagName != null) {
            this.startOpenTag(tagName);
            this.addAttribute("id", String.valueOf(ficheMeta.getId()));
            XMLUtils.addXmlLangAttribute(this, ficheMeta.getLang());
            int weight = ExtractionXMLUtils.getMainWeight(croisement);
            if (weight > 0) {
                this.addAttribute(this.tagNames.getWeightAttributeName(), String.valueOf(weight));
            }
            this.addAttribute("corpus", ficheMeta.getSubsetName());
            ExtractionXMLUtils.addCellMax(this, this.ficheFilter);
            if (this.ficheFilter.getFilterUnitList().isEmpty()) {
                this.closeEmptyTag();
                return;
            }
            this.endOpenTag();
            ExtractionXMLUtils.writeCroisement(this, croisement, this.tagNames);
        }
        this.addGroupClauseObject(ficheExtractInfo.getGroupClauseObject());
        this.filterUnitPart.addFilterUnitList(this.ficheFilter.getFilterUnitList());
        if (tagName != null) {
            this.closeTag(tagName);
        }
    }

    private void updatePointeur(FicheExtractInfo ficheExtractInfo) {
        boolean withSection = ficheExtractInfo.getFicheFilter().isWithCorpsdefiche();
        FicheMeta ficheMeta = ficheExtractInfo.getFicheMeta();
        Corpus corpus = ficheMeta.getCorpus();
        if (this.fichePointeur != null) {
            if (!this.fichePointeur.getCorpus().equals(corpus)) {
                this.fichePointeur = null;
            } else if (this.fichePointeur.isWithSection() != withSection) {
                this.fichePointeur = null;
            }
        }
        if (this.fichePointeur == null) {
            this.fichePointeur = PointeurFactory.newFichePointeur(corpus, withSection);
        }
        this.fichePointeur.setCurrentSubsetItem(ficheMeta);
        this.filterUnitPart.updatePointeur(this.fichePointeur);
    }

    private void addGroupClauseObject(Object groupClauseObject) throws IOException {
        if (groupClauseObject == null) {
            return;
        }
        if (groupClauseObject instanceof AlphabeticEntry) {
            AlphabeticEntry alphabeticEntry = (AlphabeticEntry)groupClauseObject;
            this.startOpenTag("alphabet");
            if (alphabeticEntry.isWithArticle()) {
                this.addAttribute("article", alphabeticEntry.getArticleString());
                this.addAttribute("espace", alphabeticEntry.isWithSeparationSpace() ? 1 : 0);
            }
            this.addAttribute("titre", alphabeticEntry.getEntryString());
            this.closeEmptyTag();
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "fiche";
    }

    private static List<Corpus> toCorpusList(Corpus mainCorpus, List<SubsetKey> subsetKeyList) {
        if (subsetKeyList.isEmpty()) {
            return FichothequeUtils.getParentageCorpusList(mainCorpus);
        }
        Fichotheque fichotheque = mainCorpus.getFichotheque();
        Subset mainMasterSubset = mainCorpus.getMasterSubset();
        ArrayList<Corpus> list = new ArrayList<Corpus>();
        for (SubsetKey subsetKey : subsetKeyList) {
            Corpus corpus = (Corpus)fichotheque.getSubset(subsetKey);
            if (corpus == null || corpus.equals(mainCorpus)) continue;
            Subset masterSubset = corpus.getMasterSubset();
            if (mainMasterSubset == null) {
                if (masterSubset == null || !masterSubset.equals(mainCorpus)) continue;
                list.add(corpus);
                continue;
            }
            if (!corpus.equals(mainMasterSubset) && (masterSubset == null || !masterSubset.equals(mainMasterSubset))) continue;
            list.add(corpus);
        }
        return list;
    }

    private static short typeToShort(String typeString) {
        switch (typeString) {
            case "day": 
            case "jour": {
                return 5;
            }
            case "month": 
            case "mois": {
                return 4;
            }
            case "quarter": 
            case "trimestre": {
                return 3;
            }
            case "halfyear": 
            case "semestre": {
                return 2;
            }
            case "year": 
            case "annee": {
                return 1;
            }
        }
        throw new IllegalArgumentException("unknown type = " + typeString);
    }

    private static class FilterUnitXMLPart
    extends XMLPart {
        private final ExtractParameters extractParameters;
        private final ExtractionContext extractionContext;
        private final int extractVersion;
        private final FicheItemXMLPart ficheItemXMLPart;
        private final FicheBlockXMLPart ficheBlockXMLPart;
        private final TagNames tagNames;
        private CorpusExtractXMLPart corpusExtractXMLPart = null;
        private ThesaurusExtractXMLPart thesaurusExtractXMLPart = null;
        private AlbumExtractXMLPart albumExtractXMLPart = null;
        private AddendaExtractXMLPart addendaExtractXMLPart = null;
        private FichePointeur fichePointeur;
        private IrefConverter currentIrefConverter = ExtractionUtils.SAME_CONVERTER;

        private FilterUnitXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters, TagNames tagNames) {
            super(xmlWriter);
            this.extractParameters = extractParameters;
            this.extractionContext = extractParameters.getExtractionContext();
            this.extractVersion = extractParameters.getExtractVersion();
            this.tagNames = tagNames;
            this.ficheItemXMLPart = new FicheItemXMLPart(xmlWriter, extractParameters);
            this.ficheBlockXMLPart = new FicheBlockXMLPart(xmlWriter, extractParameters);
        }

        private void updatePointeur(FichePointeur fichePointeur) {
            this.fichePointeur = fichePointeur;
            this.ficheBlockXMLPart.setDefaultCorpus(fichePointeur.getCorpus());
            this.currentIrefConverter = this.extractParameters.newIrefConverter();
        }

        private void addFilterUnitList(List<FilterUnit> filterUnitList) throws IOException {
            SelectionContext selectionContext = SelectionContextBuilder.build(this.extractionContext).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).toSelectionContext();
            for (FilterUnit filterUnit : filterUnitList) {
                if (filterUnit instanceof HeadFilterUnit) {
                    this.addEntete((HeadFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof BodyFilterUnit) {
                    this.addCorpsdefiche((BodyFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof FieldKeyFilterUnit) {
                    this.addFieldKey((FieldKeyFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof FieldNamePrefixFilterUnit) {
                    this.addPrefixedField((FieldNamePrefixFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof LotFilterUnit) {
                    this.addLot((LotFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof ChronoFilterUnit) {
                    this.addChrono();
                    continue;
                }
                if (filterUnit instanceof PhraseFilterUnit) {
                    ExtractionXMLUtils.writePhrase(this, this.fichePointeur.getCurrentSubsetItem(), ((PhraseFilterUnit)filterUnit).getName(), this.extractionContext.getLangContext(), this.extractVersion);
                    continue;
                }
                if (filterUnit instanceof AddendaExtractFilterUnit) {
                    this.addAddendaExtract((AddendaExtractFilterUnit)filterUnit, selectionContext);
                    continue;
                }
                if (filterUnit instanceof CorpusExtractFilterUnit) {
                    this.addCorpusExtract((CorpusExtractFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof ThesaurusExtractFilterUnit) {
                    this.addThesaurusExtract((ThesaurusExtractFilterUnit)filterUnit, selectionContext);
                    continue;
                }
                if (filterUnit instanceof AlbumExtractFilterUnit) {
                    this.addAlbumExtract((AlbumExtractFilterUnit)filterUnit, selectionContext);
                    continue;
                }
                if (filterUnit instanceof FicheParentageFilterUnit) {
                    this.addFicheParentage((FicheParentageFilterUnit)filterUnit);
                    continue;
                }
                if (filterUnit instanceof MasterMotcleFilterUnit) {
                    this.addMasterMotcle((MasterMotcleFilterUnit)filterUnit);
                    continue;
                }
                if (!(filterUnit instanceof DataFilterUnit)) continue;
                this.addData((DataFilterUnit)filterUnit);
            }
        }

        private void addData(DataFilterUnit dataFilterUnit) throws IOException {
            DataResolver dataResolver = this.extractionContext.getDataResolverProvider().getDataResolver(this.fichePointeur.getCorpus().getSubsetKey(), dataFilterUnit.getName());
            DataResolver.Writer resolverWriter = dataResolver.getWriter(this.fichePointeur, this.extractionContext.getLangContext());
            if (resolverWriter.isEmpty() && this.ignoreEmpty(dataFilterUnit)) {
                return;
            }
            this.startOpenTag("data");
            this.addAttribute("name", dataFilterUnit.getName());
            this.addAttribute("type", dataResolver.getType());
            this.endOpenTag();
            resolverWriter.write(this, this.extractVersion);
            this.closeTag("data");
        }

        private void addLot(LotFilterUnit lotFilterUnit) throws IOException {
            LotXMLPart lotXMLPart = new LotXMLPart(this, lotFilterUnit);
            FilterUnitXMLPart child = new FilterUnitXMLPart(lotXMLPart, this.extractParameters, this.tagNames);
            child.updatePointeur(this.fichePointeur);
            child.addFilterUnitList(lotFilterUnit.getFilterUnitList());
            lotXMLPart.end();
        }

        private void addEntete(HeadFilterUnit filterUnit) throws IOException {
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            this.addTitle(null);
            this.addSubtitle(null);
            for (CorpusField corpusField : corpusMetadata.getPropList()) {
                this.addProp(corpusField, null, filterUnit);
            }
            for (CorpusField corpusField : corpusMetadata.getInfoList()) {
                this.addInfo(corpusField, null, filterUnit);
            }
            this.addRedacteurs(null);
        }

        private Object getFieldOptionObject(CorpusField corpusField, FilterUnit filterUnit) {
            switch (corpusField.getFicheItemType()) {
                case "image": 
                case "link": {
                    return corpusField.getStringOption("baseUrl");
                }
                case "date": {
                    String labelType = filterUnit.getFirstValue("labeltype");
                    if (labelType != null) {
                        try {
                            return FicheXMLPart.typeToShort(labelType);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                case "amount": {
                    return filterUnit.getFirstValue("subunit");
                }
            }
            return null;
        }

        private void addCorpsdefiche(BodyFilterUnit filterUnit) throws IOException {
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            for (CorpusField corpusField : corpusMetadata.getSectionList()) {
                this.addSection(corpusField.getFieldKey(), null, filterUnit);
            }
        }

        private void addFieldKey(FieldKeyFilterUnit fieldKeyFilterUnit) throws IOException {
            FieldKey fieldKey = fieldKeyFilterUnit.getFieldKey();
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
            if (corpusField == null) {
                return;
            }
            block0 : switch (fieldKey.getCategory()) {
                case 1: {
                    this.addProp(corpusField, null, fieldKeyFilterUnit);
                    break;
                }
                case 2: {
                    this.addInfo(corpusField, null, fieldKeyFilterUnit);
                    break;
                }
                case 3: {
                    this.addSection(fieldKey, null, fieldKeyFilterUnit);
                    break;
                }
                case 0: {
                    switch (fieldKey.getKeyString()) {
                        case "title": {
                            this.addTitle(fieldKeyFilterUnit);
                            break block0;
                        }
                        case "subtitle": {
                            this.addSubtitle(fieldKeyFilterUnit);
                            break block0;
                        }
                        case "lang": {
                            this.addLang(fieldKeyFilterUnit);
                            break block0;
                        }
                        case "owners": {
                            this.addRedacteurs(fieldKeyFilterUnit);
                            break block0;
                        }
                        case "id": {
                            break block0;
                        }
                    }
                    throw new SwitchException("Unknown special field = " + fieldKey.getKeyString());
                }
                default: {
                    throw new SwitchException("Unknown category = " + fieldKey.getCategory());
                }
            }
        }

        private void addPrefixedField(FieldNamePrefixFilterUnit filterUnit) throws IOException {
            String prefix = filterUnit.getPrefix();
            switch (filterUnit.getCategory()) {
                case 1: {
                    this.addPrefixedProp(prefix, filterUnit);
                    break;
                }
                case 2: {
                    this.addPrefixedInfo(prefix, filterUnit);
                    break;
                }
                case 3: {
                    this.addPrefixedSection(prefix, filterUnit);
                }
            }
        }

        private void addPrefixedProp(String prefix, FilterUnit filterUnit) throws IOException {
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            for (CorpusField corpusField : corpusMetadata.getPropList()) {
                FieldNameInfo fieldNameInfo = FieldNameInfo.testPrefix(corpusField.getFieldKey(), prefix);
                if (fieldNameInfo == null) continue;
                this.addProp(corpusField, fieldNameInfo, filterUnit);
            }
        }

        private void addPrefixedInfo(String prefix, FilterUnit filterUnit) throws IOException {
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            for (CorpusField corpusField : corpusMetadata.getInfoList()) {
                FieldNameInfo fieldNameInfo = FieldNameInfo.testPrefix(corpusField.getFieldKey(), prefix);
                if (fieldNameInfo == null) continue;
                this.addInfo(corpusField, fieldNameInfo, filterUnit);
            }
        }

        private void addPrefixedSection(String prefix, FilterUnit filterUnit) throws IOException {
            CorpusMetadata corpusMetadata = this.getCorpusMetatdata();
            for (CorpusField corpusField : corpusMetadata.getSectionList()) {
                FieldKey fieldKey = corpusField.getFieldKey();
                FieldNameInfo fieldNameInfo = FieldNameInfo.testPrefix(fieldKey, prefix);
                if (fieldNameInfo == null) continue;
                this.addSection(fieldKey, fieldNameInfo, filterUnit);
            }
        }

        private void addTitle(FilterUnit filterUnit) throws IOException {
            String title = (String)this.fichePointeur.getValue(FieldKey.TITLE);
            if (title == null) {
                return;
            }
            String titleTagName = this.tagNames.getTitleTagName();
            this.startOpenTag(titleTagName);
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            this.addSimpleElement("item", title);
            this.closeTag(titleTagName);
        }

        private void addSubtitle(FilterUnit filterUnit) throws IOException {
            ParaItem para = (ParaItem)this.fichePointeur.getValue(FieldKey.SUBTITLE);
            if (para == null) {
                return;
            }
            String subtitleTagName = this.tagNames.getSubtitleTagName();
            this.startOpenTag(subtitleTagName);
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            this.ficheItemXMLPart.addPara(para, this.currentIrefConverter);
            this.closeTag(subtitleTagName);
        }

        private void addRedacteurs(FilterUnit filterUnit) throws IOException {
            FicheItems ficheItems = (FicheItems)this.fichePointeur.getValue(FieldKey.OWNERS);
            if (ficheItems == null) {
                return;
            }
            String ownersTagName = this.tagNames.getOwnersTagName();
            this.startOpenTag(ownersTagName);
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            this.ficheItemXMLPart.addFicheItems(ficheItems, null, this.currentIrefConverter);
            this.closeTag(ownersTagName);
        }

        private void addProp(CorpusField corpusField, FieldNameInfo fieldNameInfo, FilterUnit filterUnit) throws IOException {
            String propTagName = this.tagNames.getPropTagName();
            FieldKey fieldKey = corpusField.getFieldKey();
            Object fieldOptionObject = this.getFieldOptionObject(corpusField, filterUnit);
            FicheItem ficheItem = (FicheItem)this.fichePointeur.getValue(fieldKey);
            if (ficheItem == null && this.ignoreEmpty(filterUnit)) {
                return;
            }
            this.startOpenTag(propTagName);
            this.addAttribute("name", fieldKey.getFieldName());
            if (this.extractVersion == 1) {
                this.addAttribute("type", fieldKey.getFieldName());
            }
            if (fieldNameInfo != null) {
                this.addAttribute("part1", fieldNameInfo.getPart1());
                this.addAttribute("part2", fieldNameInfo.getPart2());
            }
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            if (ficheItem != null) {
                this.ficheItemXMLPart.addFicheItem(ficheItem, fieldOptionObject, this.currentIrefConverter);
            }
            this.closeTag(propTagName);
        }

        private void addInfo(CorpusField corpusField, FieldNameInfo fieldNameInfo, FilterUnit filterUnit) throws IOException {
            FieldKey fieldKey = corpusField.getFieldKey();
            Object fieldOptionObject = this.getFieldOptionObject(corpusField, filterUnit);
            FicheItems ficheItems = (FicheItems)this.fichePointeur.getValue(fieldKey);
            if (ficheItems == null && this.ignoreEmpty(filterUnit)) {
                return;
            }
            String infoTagName = this.tagNames.getInfoTagName();
            this.startOpenTag(infoTagName);
            this.addAttribute("name", fieldKey.getFieldName());
            if (this.extractVersion == 1) {
                this.addAttribute("type", fieldKey.getFieldName());
            }
            if (fieldNameInfo != null) {
                this.addAttribute("part1", fieldNameInfo.getPart1());
                this.addAttribute("part2", fieldNameInfo.getPart2());
            }
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            if (ficheItems != null) {
                this.ficheItemXMLPart.addFicheItems(ficheItems, fieldOptionObject, this.currentIrefConverter);
            }
            this.closeTag(infoTagName);
        }

        private void addSection(FieldKey fieldKey, FieldNameInfo fieldNameInfo, FilterUnit filterUnit) throws IOException {
            FicheBlocks blockList = (FicheBlocks)this.fichePointeur.getValue(fieldKey);
            if (blockList == null && this.ignoreEmpty(filterUnit)) {
                return;
            }
            this.startOpenTag("section");
            this.addAttribute("name", fieldKey.getFieldName());
            if (this.extractVersion == 1) {
                this.addAttribute("type", fieldKey.getFieldName());
            }
            if (fieldNameInfo != null) {
                this.addAttribute("part1", fieldNameInfo.getPart1());
                this.addAttribute("part2", fieldNameInfo.getPart2());
            }
            ExtractionXMLUtils.addFilterParameters(this, filterUnit);
            this.endOpenTag();
            if (blockList != null) {
                this.ficheBlockXMLPart.addFicheBlocks(blockList, this.currentIrefConverter);
            }
            this.closeTag("section");
        }

        private void addChrono() throws IOException {
            FicheMeta ficheMeta = (FicheMeta)this.fichePointeur.getCurrentSubsetItem();
            FuzzyDate creationDate = ficheMeta.getCreationDate();
            if (creationDate != null) {
                this.openTag("chrono");
                this.ficheItemXMLPart.addDate(new DateItem(creationDate), null);
                FuzzyDate modificationDate = ficheMeta.getModificationDate();
                if (!modificationDate.equals(creationDate)) {
                    this.ficheItemXMLPart.addDate(new DateItem(modificationDate), null);
                }
                this.closeTag("chrono");
            }
        }

        private void addLang(FilterUnit filterUnit) throws IOException {
            Lang lang = ((FicheMeta)this.fichePointeur.getCurrentSubsetItem()).getLang();
            if (lang == null && this.ignoreEmpty(filterUnit)) {
                return;
            }
            this.openTag("lang");
            if (lang != null) {
                this.ficheItemXMLPart.addLanguage(new LanguageItem(lang));
            }
            this.closeTag("lang");
        }

        private void addFicheParentage(FicheParentageFilterUnit filterUnit) throws IOException {
            Corpus currentCorpus = this.fichePointeur.getCorpus();
            List corpusList = FicheXMLPart.toCorpusList(currentCorpus, filterUnit.getSubsetKeyList());
            if (corpusList.isEmpty()) {
                return;
            }
            int id = this.fichePointeur.getCurrentSubsetItem().getId();
            FicheXMLPart ficheXMLPart = new FicheXMLPart(this.getXMLWriter(), this.extractParameters);
            FicheFilter ficheFilter = filterUnit.getFicheFilter();
            Predicate<FicheMeta> fichePredicate = this.extractParameters.getFichePredicate();
            if (fichePredicate == null) {
                fichePredicate = EligibilityUtils.ALL_FICHE_PREDICATE;
            }
            for (Corpus otherCorpus : corpusList) {
                FicheMeta ficheMeta;
                if (!this.extractionContext.getSubsetAccessPredicate().test(otherCorpus) || (ficheMeta = otherCorpus.getFicheMetaById(id)) == null || !fichePredicate.test(ficheMeta)) continue;
                FicheExtractInfo ficheExtractInfo = ExtractionXMLUtils.toFicheExtractInfo(ficheMeta, ficheFilter);
                ficheXMLPart.addFiche(ficheExtractInfo);
            }
        }

        private void addMasterMotcle(MasterMotcleFilterUnit filterUnit) throws IOException {
            Corpus currentCorpus = this.fichePointeur.getCorpus();
            Subset masterSubset = currentCorpus.getMasterSubset();
            if (masterSubset == null || !(masterSubset instanceof Thesaurus)) {
                return;
            }
            if (!this.extractionContext.getSubsetAccessPredicate().test(masterSubset)) {
                return;
            }
            Motcle masterMotcle = (Motcle)masterSubset.getSubsetItemById(this.fichePointeur.getCurrentSubsetItem().getId());
            MotcleXMLPart motcleXMLPart = new MotcleXMLPart(this.getXMLWriter(), this.extractParameters);
            motcleXMLPart.addMotcle(ExtractionXMLUtils.toMotcleExtractInfo(masterMotcle, filterUnit.getMotcleFilter()));
        }

        private void addCorpusExtract(CorpusExtractFilterUnit corpusExtractFilterUnit) throws IOException {
            CorpusExtractDef corpusExtractDef = corpusExtractFilterUnit.getCorpusExtractDef();
            CorpusExtractor corpusExtractor = this.extractionContext.getExtractorProvider().getCorpusExtractor(corpusExtractDef);
            SelectionContext selectionContext = SelectionContextBuilder.build(this.extractionContext).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).setFichePredicate(this.extractParameters.getFichePredicate()).setCurrentCorpus(this.fichePointeur.getCorpus()).toSelectionContext();
            FicheSelector ficheSelector = FicheSelectorBuilder.init(selectionContext).addAll(corpusExtractDef.getConditionEntryList()).toFicheSelector();
            SubsetItemPointeur pointeur = PointeurUtils.checkMasterPointeur(this.fichePointeur, corpusExtractDef.isMaster());
            for (Corpus other : ficheSelector.getCorpusList()) {
                Croisements croisements = pointeur.getCroisements(other);
                for (Croisements.Entry entry : croisements.getEntryList()) {
                    FicheMeta ficheMeta2 = (FicheMeta)entry.getSubsetItem();
                    Croisement filteredCroisement = ficheSelector.isSelected(ficheMeta2, entry.getCroisement());
                    if (filteredCroisement == null) continue;
                    corpusExtractor.add(ficheMeta2, filteredCroisement);
                }
            }
            if (this.corpusExtractXMLPart == null) {
                this.corpusExtractXMLPart = new CorpusExtractXMLPart(this.getXMLWriter(), this.extractParameters);
            }
            this.corpusExtractXMLPart.addCorpusExtract(corpusExtractor.getCorpusExtractResult(), corpusExtractFilterUnit);
        }

        private void addThesaurusExtract(ThesaurusExtractFilterUnit thesaurusExtractFilterUnit, SelectionContext selectionContext) throws IOException {
            ThesaurusExtractDef thesaurusExtractDef = thesaurusExtractFilterUnit.getThesaurusExtractDef();
            ThesaurusExtractor thesaurusExtractor = this.extractionContext.getExtractorProvider().getThesaurusExtractor(thesaurusExtractDef);
            MotcleSelector motcleSelector = MotcleSelectorBuilder.init(selectionContext).addAll(thesaurusExtractDef.getConditionEntryList()).toMotcleSelector();
            SubsetItemPointeur pointeur = PointeurUtils.checkMasterPointeur(this.fichePointeur, thesaurusExtractDef.isMaster());
            for (Thesaurus thesaurus : motcleSelector.getThesaurusList()) {
                Croisements croisements = pointeur.getCroisements(thesaurus);
                for (Croisements.Entry entry : croisements.getEntryList()) {
                    Motcle motcle = (Motcle)entry.getSubsetItem();
                    Croisement filteredCroisement = motcleSelector.isSelected(motcle, entry.getCroisement());
                    if (filteredCroisement == null) continue;
                    thesaurusExtractor.add(motcle, filteredCroisement);
                }
            }
            if (this.thesaurusExtractXMLPart == null) {
                this.thesaurusExtractXMLPart = new ThesaurusExtractXMLPart(this.getXMLWriter(), this.extractParameters);
            }
            this.thesaurusExtractXMLPart.addThesaurusExtract(thesaurusExtractor.getThesaurusExtractResult(), thesaurusExtractFilterUnit);
        }

        private void addAlbumExtract(AlbumExtractFilterUnit albumExtractFilterUnit, SelectionContext selectionContext) throws IOException {
            AlbumExtractDef albumExtractDef = albumExtractFilterUnit.getAlbumExtractDef();
            AlbumExtractor albumExtractor = this.extractionContext.getExtractorProvider().getAlbumExtractor(albumExtractDef);
            IllustrationSelector illustrationSelector = IllustrationSelectorBuilder.init(selectionContext).addAll(albumExtractDef.getConditionEntryList()).toIllustrationSelector();
            for (Album album : illustrationSelector.getAlbumList()) {
                Croisements croisements = this.fichePointeur.getCroisements(album);
                for (Croisements.Entry entry : croisements.getEntryList()) {
                    Illustration illustration = (Illustration)entry.getSubsetItem();
                    Croisement filteredCroisement = illustrationSelector.isSelected(illustration, entry.getCroisement());
                    if (filteredCroisement == null) continue;
                    albumExtractor.add(illustration, filteredCroisement);
                }
            }
            if (this.albumExtractXMLPart == null) {
                this.albumExtractXMLPart = new AlbumExtractXMLPart(this.getXMLWriter(), this.extractParameters);
            }
            this.albumExtractXMLPart.addAlbumExtract(albumExtractor.getAlbumExtractResult(), albumExtractFilterUnit);
        }

        private void addAddendaExtract(AddendaExtractFilterUnit addendaExtractFilterUnit, SelectionContext selectionContext) throws IOException {
            AddendaExtractDef addendaExtractDef = addendaExtractFilterUnit.getAddendaExtractDef();
            AddendaExtractor addendaExtractor = this.extractionContext.getExtractorProvider().getAddendaExtractor(addendaExtractDef);
            DocumentSelector documentSelector = DocumentSelectorBuilder.init(selectionContext).addAll(addendaExtractDef.getConditionEntryList()).toDocumentSelector();
            for (Addenda addenda : documentSelector.getAddendaList()) {
                Croisements croisements = this.fichePointeur.getCroisements(addenda);
                for (Croisements.Entry entry : croisements.getEntryList()) {
                    Document document = (Document)entry.getSubsetItem();
                    Croisement filteredCroisement = documentSelector.isSelected(document, entry.getCroisement());
                    if (filteredCroisement == null) continue;
                    addendaExtractor.add(document, filteredCroisement);
                }
            }
            if (this.addendaExtractXMLPart == null) {
                this.addendaExtractXMLPart = new AddendaExtractXMLPart(this.getXMLWriter(), this.extractParameters);
            }
            this.addendaExtractXMLPart.addAddendaExtract(addendaExtractor.getAddendaExtractResult(), addendaExtractFilterUnit);
        }

        private CorpusMetadata getCorpusMetatdata() {
            return this.fichePointeur.getCorpus().getCorpusMetadata();
        }

        private boolean ignoreEmpty(FilterUnit filterUnit) {
            if (this.extractVersion == 1) {
                return true;
            }
            return this.extractParameters.hideIfEmpty(filterUnit);
        }
    }

    private static class LotXMLPart
    extends FillControllerXMLPart {
        private final String tagName;
        private final XMLWriter xmlWriter;
        private boolean openDone = false;

        private LotXMLPart(XMLWriter xmlWriter, LotFilterUnit lotFilterUnit) {
            super(xmlWriter);
            this.tagName = this.getTagName(lotFilterUnit.getTagNameInfo());
            this.xmlWriter = xmlWriter;
        }

        @Override
        public void controlFill() throws IOException {
            if (this.tagName != null) {
                this.xmlWriter.openTag(this.tagName);
                this.openDone = true;
            }
        }

        private void end() throws IOException {
            if (this.tagName != null && this.openDone) {
                this.xmlWriter.closeTag(this.tagName);
            }
        }

        private String getTagName(TagNameInfo tagNameInfo) {
            switch (tagNameInfo.getType()) {
                case 3: {
                    return tagNameInfo.getCustomTagName();
                }
                case 2: {
                    return null;
                }
            }
            return "lot";
        }
    }
}

