/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import net.fichotheque.selection.RangeCondition;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;

public class RangeConditionBuilder {
    private boolean exclude = false;
    private Ranges ranges;

    public RangeConditionBuilder(Ranges ranges) {
        if (ranges == null || !RangeUtils.isPositiveRanges(ranges)) {
            throw new IllegalArgumentException("ranges is not positive");
        }
        this.ranges = ranges;
    }

    public RangeConditionBuilder setExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public RangeConditionBuilder setRanges(Ranges ranges) {
        if (ranges == null || !RangeUtils.isPositiveRanges(ranges)) {
            throw new IllegalArgumentException("ranges is not positive");
        }
        this.ranges = ranges;
        return this;
    }

    public RangeCondition toRangeCondition() {
        return new InternalRangeCondition(this.exclude, this.ranges);
    }

    public static RangeConditionBuilder init(Ranges ranges) {
        return new RangeConditionBuilder(ranges);
    }

    private static class InternalRangeCondition
    implements RangeCondition {
        private final boolean exclude;
        private final Ranges ranges;

        private InternalRangeCondition(boolean exclude, Ranges ranges) {
            this.exclude = exclude;
            this.ranges = ranges;
        }

        @Override
        public boolean isExclude() {
            return this.exclude;
        }

        @Override
        public Ranges getRanges() {
            return this.ranges;
        }
    }
}

