/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.pointeurs;

import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.pointeurs.AbstractPointeur;

class FichePointeurImpl
extends AbstractPointeur
implements FichePointeur {
    private boolean withSection;
    private Corpus corpus;
    private FicheAPI fiche;
    private FicheMeta currentFicheMeta;
    private final Map<FieldKey, Object> fieldBufferMap = new HashMap<FieldKey, Object>();
    private boolean cacheEnable = false;
    private Map<Integer, FicheAPI> cacheFicheMap;

    FichePointeurImpl(Corpus corpus, boolean withSection) {
        super(corpus);
        this.withSection = withSection;
        this.corpus = corpus;
    }

    FichePointeurImpl(FicheMeta ficheMeta, FicheAPI fiche) {
        this(ficheMeta.getCorpus(), true);
        this.setCurrentSubsetItem(ficheMeta);
        this.fiche = fiche;
        if (fiche != null) {
            this.initTitle(fiche.getTitle());
        }
    }

    @Override
    protected void initCurrentSubsetItem(SubsetItem subsetItem) {
        FicheMeta ficheMeta;
        this.currentFicheMeta = ficheMeta = (FicheMeta)subsetItem;
        this.fieldBufferMap.clear();
        this.fiche = null;
        if (ficheMeta != null) {
            this.initTitle(ficheMeta.getTitle());
            this.fieldBufferMap.put(FieldKey.ID, ficheMeta.getId());
        }
    }

    @Override
    public boolean isWithSection() {
        return this.withSection;
    }

    @Override
    public void enableCache(boolean enable) {
        if (this.cacheEnable == enable) {
            return;
        }
        this.cacheEnable = enable;
        if (enable) {
            this.cacheFicheMap = new HashMap<Integer, FicheAPI>();
        } else {
            this.cacheFicheMap.clear();
            this.cacheFicheMap = null;
        }
    }

    @Override
    public Object getValue(FieldKey fieldKey) {
        if (this.currentFicheMeta == null) {
            return null;
        }
        Object obj = this.fieldBufferMap.get(fieldKey);
        if (obj != null) {
            if (obj.equals(Boolean.FALSE)) {
                return null;
            }
            return obj;
        }
        if (!this.withSection && fieldKey.isSection()) {
            this.withSection = true;
            if (this.fiche != null) {
                this.fiche = null;
                if (this.cacheEnable) {
                    this.cacheFicheMap.remove(this.currentFicheMeta.getId());
                }
            }
        }
        this.initFiche();
        obj = this.fiche.getValue(fieldKey);
        if (obj == null) {
            this.fieldBufferMap.put(fieldKey, Boolean.FALSE);
        } else {
            this.fieldBufferMap.put(fieldKey, obj);
        }
        return obj;
    }

    private void initFiche() {
        FicheAPI cacheFiche;
        if (this.fiche != null) {
            return;
        }
        if (this.cacheEnable && (cacheFiche = this.cacheFicheMap.get(this.currentFicheMeta.getId())) != null) {
            this.fiche = cacheFiche;
            return;
        }
        this.fiche = this.currentFicheMeta.getFicheAPI(this.withSection);
        if (this.cacheEnable) {
            this.cacheFicheMap.put(this.currentFicheMeta.getId(), this.fiche);
        }
    }

    private void initTitle(String title) {
        if (title.length() > 0) {
            this.fieldBufferMap.put(FieldKey.TITLE, title);
        } else {
            this.fieldBufferMap.put(FieldKey.TITLE, Boolean.FALSE);
        }
    }
}

