/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus;

import java.util.Collection;
import java.util.List;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ThesaurusEditor;

public class ChildrenReorderEngine {
    private final ThesaurusEditor thesaurusEditor;

    public ChildrenReorderEngine(ThesaurusEditor thesaurusEditor) {
        this.thesaurusEditor = thesaurusEditor;
    }

    public void reorder(Motcle motcle, Collection<Motcle> newOrder) {
        List<Motcle> currentChildren = motcle != null ? motcle.getChildList() : this.thesaurusEditor.getThesaurus().getFirstLevelList();
        int size = currentChildren.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            return;
        }
        int p = 0;
        for (Motcle child : newOrder) {
            if (!this.isParent(motcle, child)) continue;
            this.thesaurusEditor.setChildIndex(child, p);
            ++p;
        }
    }

    private boolean isParent(Motcle parent, Motcle child) {
        if (parent == null) {
            if (child.getParent() != null) {
                return false;
            }
            return child.getThesaurus().equals(this.thesaurusEditor.getThesaurus());
        }
        Motcle otherParent = child.getParent();
        if (otherParent == null) {
            return false;
        }
        return otherParent.equals(parent);
    }
}

