/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.croisement.LienToken;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.annotation.Nullable;

public class LienBufferParser {
    private LienBufferParser() {
    }

    public static LienBuffer parse(Fichotheque fichotheque, String tokenString, short subsetCategory) throws ParseException {
        return LienBufferParser.parse(fichotheque, tokenString, subsetCategory, null, null);
    }

    public static LienBuffer parse(Fichotheque fichotheque, String tokenString, short subsetCategory, Subset defaultSubset, String mode) throws ParseException {
        LienToken lienToken = LienToken.parse(tokenString);
        int weight = lienToken.getWeight();
        if (mode == null) {
            mode = lienToken.getMode();
        }
        SubsetItem subsetItem = FichothequeUtils.parseGlobalId(lienToken.getText(), fichotheque, subsetCategory, defaultSubset);
        return new LienBuffer(subsetItem, mode, weight);
    }

    public static LienBuffer parseId(Subset subset, String tokenString, @Nullable String mode, int weightFilter) throws ParseException {
        int id;
        LienToken lienToken = LienToken.parse(tokenString);
        int weight = weightFilter < 1 ? lienToken.getWeight() : weightFilter;
        if (mode == null) {
            mode = lienToken.getMode();
        }
        try {
            id = Integer.parseInt(lienToken.getText());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(tokenString, 0);
        }
        if (id < 0) {
            throw new ParseException(tokenString, 0);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw new ParseException(tokenString, 0);
        }
        return new LienBuffer(subsetItem, mode, weight);
    }

    public static LienBuffer parseIdalpha(Thesaurus thesaurus, String tokenString, String mode, int weightFilter) throws ParseException {
        Motcle motcle;
        LienToken lienToken = LienToken.parse(tokenString);
        int weight = weightFilter < 1 ? lienToken.getWeight() : weightFilter;
        if (mode == null) {
            mode = lienToken.getMode();
        }
        if ((motcle = thesaurus.getMotcleByIdalpha(lienToken.getText())) == null) {
            throw new ParseException(tokenString, 0);
        }
        return new LienBuffer(motcle, mode, weight);
    }
}

