/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.StringUtils;

class DocumentChangeToken {
    private final Addenda addenda;
    private final int id;
    private final DocumentChangeInfo documentChangeInfo;

    DocumentChangeToken(Addenda addenda, int id, DocumentChangeInfo documentChangeInfo) {
        this.addenda = addenda;
        this.id = id;
        this.documentChangeInfo = documentChangeInfo;
    }

    static DocumentChangeToken parse(String tokenString, Addenda addenda) {
        int documentid;
        int idx = tokenString.indexOf(58);
        if (idx == -1) {
            return null;
        }
        try {
            documentid = Integer.parseInt(tokenString.substring(0, idx));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        DocumentChangeInfo documentChangeInfo = DocumentChangeInfo.parse(tokenString.substring(idx + 1));
        return new DocumentChangeToken(addenda, documentid, documentChangeInfo);
    }

    void save(FichothequeEditor fichothequeEditor, File tmpDirectory) {
        String extension;
        AddendaEditor addendaEditor = fichothequeEditor.getAddendaEditor(this.addenda);
        if (addendaEditor == null) {
            return;
        }
        Document document = (Document)this.addenda.getSubsetItemById(this.id);
        if (document == null) {
            return;
        }
        String newBasename = this.documentChangeInfo.getNewBasename();
        if (newBasename != null) {
            newBasename = AddendaUtils.checkBasename(newBasename, this.addenda);
            try {
                addendaEditor.setBasename(document, newBasename);
            }
            catch (ParseException | ExistingNameException e) {
                throw new ShouldNotOccurException("Check done before");
            }
        }
        int tmpFileNameCount = this.documentChangeInfo.getTmpFileCount();
        for (int i = 0; i < tmpFileNameCount; ++i) {
            File f;
            FileName tmpFileName = this.documentChangeInfo.getTmpFileName(i);
            extension = tmpFileName.getExtension();
            if (extension == null || (f = DocumentChangeToken.toTmpFile(tmpDirectory, tmpFileName.toString())) == null) continue;
            DocumentChangeToken.updateVersion(addendaEditor, document, f, extension);
        }
        int removedExtensionCount = this.documentChangeInfo.getRemovedExtensionCount();
        for (int i = 0; i < removedExtensionCount; ++i) {
            extension = this.documentChangeInfo.getRemovedExtension(i);
            addendaEditor.removeVersion(document, extension);
        }
    }

    static File toTmpFile(File tmpDirectory, String tmpFileName) {
        if ((tmpFileName = StringUtils.normalizeRelativePath(tmpFileName)) == null) {
            return null;
        }
        File f = new File(tmpDirectory, tmpFileName);
        if (!f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return null;
        }
        return f;
    }

    static void updateVersion(AddendaEditor addendaEditor, Document document, File f, String extension) {
        try (FileInputStream is = new FileInputStream(f);){
            addendaEditor.saveVersion(document, extension, is);
        }
        catch (ParseException e) {
            throw new ShouldNotOccurException("Check done before");
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }
}

