/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.tools.importation.parsers.Row;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelChangeBuilder;

public abstract class LabelHandler {
    protected int uniqueIndex = -1;
    protected List<Integer> indexList;

    protected LabelHandler() {
    }

    public abstract void handle(Row var1, LabelChangeBuilder var2) throws ErrorMessageException;

    public boolean addIndex(int index) {
        if (index == -1) {
            this.uniqueIndex = index;
        } else {
            this.uniqueIndex = -2;
            if (this.indexList == null) {
                this.indexList = new ArrayList<Integer>();
            }
            this.indexList.add(index);
        }
        return true;
    }

    private static void handleLabel(LabelHandler handler, Lang lang, Row row, LabelChangeBuilder changeLabelHolderBuilder) {
        int columnCount = row.getColumnCount();
        CleanedString cs = null;
        if (handler.uniqueIndex > -1) {
            if (handler.uniqueIndex < columnCount) {
                cs = CleanedString.newInstance(row.getColumnValue(handler.uniqueIndex));
            }
        } else {
            StringBuilder buf = new StringBuilder();
            int indexCount = handler.indexList.size();
            for (int i = 0; i < indexCount; ++i) {
                String val;
                int index = handler.indexList.get(i);
                if (index >= columnCount || (val = row.getColumnValue(index)) == null) continue;
                buf.append(val);
            }
            cs = CleanedString.newInstance(buf.toString());
        }
        changeLabelHolderBuilder.putLabel(lang, cs);
    }

    public static class ByLang
    extends LabelHandler {
        private final Lang lang;

        public ByLang(Lang lang) {
            this.lang = lang;
        }

        @Override
        public void handle(Row row, LabelChangeBuilder changeLabelHolderBuilder) throws ErrorMessageException {
            LabelHandler.handleLabel((LabelHandler)this, this.lang, row, changeLabelHolderBuilder);
        }
    }

    public static class Babelien
    extends LabelHandler {
        private int langIndex = -1;

        public boolean hasLangIndex() {
            return this.langIndex != -1;
        }

        public boolean hasLibIndices() {
            return this.uniqueIndex != -1;
        }

        public void setLangIndex(int langIndex) {
            this.langIndex = langIndex;
        }

        @Override
        public void handle(Row row, LabelChangeBuilder changeLabelHolderBuilder) throws ErrorMessageException {
            int columnCount = row.getColumnCount();
            if (this.langIndex < columnCount) {
                String langString = row.getColumnValue(this.langIndex).trim();
                try {
                    Lang lang = Lang.parse(langString);
                    LabelHandler.handleLabel((LabelHandler)this, lang, row, changeLabelHolderBuilder);
                }
                catch (ParseException pe) {
                    throw new ErrorMessageException("_ error.wrong.lang", langString);
                }
            }
        }
    }
}

