/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.dom.FicheDOMReader;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.dom.ImportationDomUtils;
import net.fichotheque.tools.importation.dom.LiensImportDOMReader;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FicheImportDOMReader {
    private final EditFicheImportBuilder ficheImportBuilder;
    private final Fichotheque fichotheque;
    private final ImportationContext importationContext;

    public FicheImportDOMReader(EditFicheImportBuilder ficheImportBuilder, Fichotheque fichotheque, ImportationContext importationContext) {
        this.ficheImportBuilder = ficheImportBuilder;
        this.fichotheque = fichotheque;
        this.importationContext = importationContext;
    }

    public FicheImportDOMReader read(Element element) {
        RootConsumer rootConsumer = new RootConsumer();
        DOMUtils.readChildren(element, rootConsumer);
        rootConsumer.readOthers(element);
        return this;
    }

    public static FicheImportDOMReader init(EditFicheImportBuilder ficheImportBuilder, Fichotheque fichotheque, ImportationContext importationContext) {
        return new FicheImportDOMReader(ficheImportBuilder, fichotheque, importationContext);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final FicheDOMReader ficheDOMReader;
        private boolean withOthers = false;

        private RootConsumer() {
            this.ficheDOMReader = new FicheDOMReader(FicheImportDOMReader.this.importationContext.getHtmlCleaner());
            this.ficheDOMReader.setAppend(true);
        }

        public void readOthers(Element element) {
            if (!this.withOthers) {
                return;
            }
            FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder().appendFiche(this.ficheDOMReader.readFlatFiche(element));
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "fiche": {
                    FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder().appendFiche(this.ficheDOMReader.readFiche(element));
                    break;
                }
                case "attr": {
                    ImportationDomUtils.readAttrElement(element, FicheImportDOMReader.this.ficheImportBuilder.getAttributeChangeBuilder());
                    break;
                }
                case "chrono": {
                    String creationString = element.getAttribute("creation");
                    if (creationString.length() <= 0) break;
                    try {
                        FicheImportDOMReader.this.ficheImportBuilder.setCreationDate(FuzzyDate.parse(creationString));
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "removed": {
                    DOMUtils.readChildren(element, new RemovedConsumer(FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder()));
                    break;
                }
                case "liens": {
                    String type = element.getAttribute("type");
                    LiensImportDOMReader.init(FicheImportDOMReader.this.fichotheque, FicheImportDOMReader.this.ficheImportBuilder.getLiensImportBuilder(), type).read(element);
                    break;
                }
                case "lang": {
                    String langString = XMLUtils.getData(element);
                    if (langString.isEmpty()) {
                        FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder().setLang(null);
                        break;
                    }
                    try {
                        Lang lang = Lang.parse(langString);
                        FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder().setLang(lang);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case "html": {
                    this.readHtml(element);
                    break;
                }
                default: {
                    this.withOthers = true;
                }
            }
        }

        private void readHtml(Element element) {
            FicheChangeBuilder ficheChangeBuilder = FicheImportDOMReader.this.ficheImportBuilder.getFicheChangeBuilder();
            String cdata = XMLUtils.getRawData(element);
            try {
                FieldKey convertFieldKey = FieldKey.parse(element.getAttribute("convert"));
                FicheBlocks ficheBlocks = FicheImportDOMReader.this.importationContext.getHtmlConverter().convertHtml(cdata);
                if (convertFieldKey.isSection()) {
                    ficheChangeBuilder.putSection(convertFieldKey, ficheBlocks);
                }
            }
            catch (ParseException convertFieldKey) {
                // empty catch block
            }
            try {
                FieldKey archiveFieldKey = FieldKey.parse(element.getAttribute("archive"));
                if (archiveFieldKey.isSection()) {
                    Cdatadiv cdatadiv = new Cdatadiv();
                    cdatadiv.setCdata(FicheImportDOMReader.this.importationContext.getHtmlCleaner().cleanHtml(cdata));
                    ficheChangeBuilder.putSection(archiveFieldKey, FicheUtils.toFicheBlocks(cdatadiv));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static class RemovedConsumer
    implements Consumer<Element> {
        private final FicheChangeBuilder ficheChangeBuilder;

        private RemovedConsumer(FicheChangeBuilder ficheChangeBuilder) {
            this.ficheChangeBuilder = ficheChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "key": {
                    try {
                        FieldKey fieldKey = FieldKey.parse(XMLUtils.getData(element));
                        this.ficheChangeBuilder.removeField(fieldKey);
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

