/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.include.LiageTest;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FormatterUtils;

public class LiageTokenizer
implements Tokenizer {
    private final FicheMetaFormatter ficheMetaFormatter;
    private final boolean globalSelect;
    private final LiageTest liageTest;

    public LiageTokenizer(FicheMetaFormatter ficheMetaFormatter, boolean globalSelect, LiageTest liageTest) {
        this.ficheMetaFormatter = ficheMetaFormatter;
        this.globalSelect = globalSelect;
        this.liageTest = liageTest;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        List<FicheMetaWrapper> wrapperList = this.getList(formatSource);
        if (wrapperList == null || wrapperList.isEmpty()) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(this.ficheMetaFormatter, wrapperList, formatSource);
    }

    private List<FicheMetaWrapper> getList(FormatSource formatSource) {
        List<Liaison> liaisons;
        Predicate<SubsetItem> predicate = null;
        if (this.globalSelect) {
            predicate = formatSource.getGlobalPredicate();
        }
        if ((liaisons = CroisementUtils.getNoList(formatSource.getSubsetItemPointeur(), "", this.liageTest, formatSource.getExtractionContext().getSubsetAccessPredicate(), predicate)).isEmpty()) {
            return null;
        }
        ArrayList<FicheMetaWrapper> wrapperList = new ArrayList<FicheMetaWrapper>();
        for (Liaison liaison : liaisons) {
            wrapperList.add(new FicheMetaWrapper((FicheMeta)liaison.getSubsetItem(), liaison.getLien().getWeight()));
        }
        return wrapperList;
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final FicheMetaFormatter ficheMetaFormatter;
        private final List<FicheMetaWrapper> wrapperList;
        private final FormatSource formatSource;

        private InternalTokens(FicheMetaFormatter ficheMetaFormatter, List<FicheMetaWrapper> wrapperList, FormatSource formatSource) {
            this.wrapperList = wrapperList;
            this.ficheMetaFormatter = ficheMetaFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.wrapperList.size();
        }

        @Override
        public String get(int i) {
            FicheMetaWrapper wrapper = this.wrapperList.get(i);
            return this.ficheMetaFormatter.formatFicheMeta(wrapper.getFicheMeta(), wrapper.getWeight(), this.formatSource);
        }
    }

    private static class FicheMetaWrapper {
        private final FicheMeta ficheMeta;
        private final int weight;

        private FicheMetaWrapper(FicheMeta ficheMeta, int weight) {
            this.ficheMeta = ficheMeta;
            this.weight = weight;
        }

        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

