/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.LiaisonSortKey;
import net.fichotheque.croisement.Lien;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.IllustrationFilter;
import net.fichotheque.extraction.run.AlbumExtractResult;
import net.fichotheque.extraction.run.AlbumExtractor;
import net.fichotheque.extraction.run.IllustrationExtractInfo;
import net.fichotheque.utils.CroisementUtils;

class AlbumExtractorImpl
implements AlbumExtractor {
    private final Map<SubsetKey, ResultBuilder> builderMap = new TreeMap<SubsetKey, ResultBuilder>();
    private final AlbumExtractDef albumExtractDef;

    AlbumExtractorImpl(AlbumExtractDef albumExtractDef) {
        this.albumExtractDef = albumExtractDef;
    }

    @Override
    public void add(Illustration illustration, Croisement croisement) {
        Album album = illustration.getAlbum();
        ResultBuilder resultBuilder = this.builderMap.get(album.getSubsetKey());
        IllustrationFilter illustrationFilter = this.albumExtractDef.getIllustrationFilter();
        if (resultBuilder == null) {
            resultBuilder = new ResultBuilder(album);
            this.builderMap.put(album.getSubsetKey(), resultBuilder);
        }
        resultBuilder.add(illustration, illustrationFilter, croisement);
    }

    @Override
    public AlbumExtractResult getAlbumExtractResult() {
        AlbumExtractResult.Entry[] array = new AlbumExtractResult.Entry[this.builderMap.size()];
        int p = 0;
        for (ResultBuilder resultBuilder : this.builderMap.values()) {
            array[p] = new InternalEntry(resultBuilder.album, resultBuilder.getIllustrationExtractInfoList());
            ++p;
        }
        InternalAlbumExtractResult albumExtractResult = new InternalAlbumExtractResult(this.albumExtractDef, new EntryList(array));
        return albumExtractResult;
    }

    private class ResultBuilder {
        private Album album;
        private final SortedMap<LiaisonSortKey, InternalIllustrationExtractInfo> map = new TreeMap<LiaisonSortKey, InternalIllustrationExtractInfo>();

        private ResultBuilder(Album album) {
            this.album = album;
        }

        private void add(Illustration illustration, IllustrationFilter illustrationFilter, Croisement croisement) {
            int position;
            if (croisement != null) {
                Lien lien = croisement.getLienList().get(0);
                position = CroisementUtils.getPosition(illustration, croisement.getCroisementKey(), lien);
            } else {
                position = this.map.size() + 1;
            }
            LiaisonSortKey key = new LiaisonSortKey(illustration.getId(), position);
            this.map.put(key, new InternalIllustrationExtractInfo(illustration, illustrationFilter, croisement));
        }

        private List<IllustrationExtractInfo> getIllustrationExtractInfoList() {
            return new IllustrationExtractInfoList(this.map.values().toArray(new IllustrationExtractInfo[this.map.size()]));
        }
    }

    private static class InternalEntry
    implements AlbumExtractResult.Entry {
        private final Album album;
        private final List<IllustrationExtractInfo> list;

        private InternalEntry(Album album, List<IllustrationExtractInfo> list) {
            this.album = album;
            this.list = list;
        }

        @Override
        public Album getAlbum() {
            return this.album;
        }

        @Override
        public List<IllustrationExtractInfo> getIllustrationExtractInfoList() {
            return this.list;
        }
    }

    private static class InternalAlbumExtractResult
    implements AlbumExtractResult {
        private final AlbumExtractDef albumExtractDef;
        private final List<AlbumExtractResult.Entry> entryList;

        private InternalAlbumExtractResult(AlbumExtractDef albumExtractDef, List<AlbumExtractResult.Entry> entryList) {
            this.albumExtractDef = albumExtractDef;
            this.entryList = entryList;
        }

        @Override
        public AlbumExtractDef getAlbumExtractDef() {
            return this.albumExtractDef;
        }

        @Override
        public List<AlbumExtractResult.Entry> getEntryList() {
            return this.entryList;
        }
    }

    private static class EntryList
    extends AbstractList<AlbumExtractResult.Entry>
    implements RandomAccess {
        private final AlbumExtractResult.Entry[] array;

        private EntryList(AlbumExtractResult.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AlbumExtractResult.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class IllustrationExtractInfoList
    extends AbstractList<IllustrationExtractInfo>
    implements RandomAccess {
        private final IllustrationExtractInfo[] array;

        private IllustrationExtractInfoList(IllustrationExtractInfo[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public IllustrationExtractInfo get(int index) {
            return this.array[index];
        }
    }

    private static class InternalIllustrationExtractInfo
    implements IllustrationExtractInfo {
        private final Illustration illustration;
        private final IllustrationFilter illustrationFilter;
        private final Croisement croisement;

        public InternalIllustrationExtractInfo(Illustration illustration, IllustrationFilter illustrationFilter, Croisement croisement) {
            this.illustration = illustration;
            this.illustrationFilter = illustrationFilter;
            this.croisement = croisement;
        }

        @Override
        public Illustration getIllustration() {
            return this.illustration;
        }

        @Override
        public IllustrationFilter getIllustrationFilter() {
            return this.illustrationFilter;
        }

        @Override
        public Croisement getCroisement() {
            return this.croisement;
        }
    }
}

