/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.scrutari;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;

class ExportInclude {
    private final boolean withAttributeFilter;
    private final Predicate<AttributeKey> attributePredicate;
    private final List<String> hookList;

    private ExportInclude(Predicate<AttributeKey> attributePredicate, List<String> hookList) {
        this.withAttributeFilter = attributePredicate != null;
        this.attributePredicate = attributePredicate;
        this.hookList = hookList;
    }

    boolean isWithAttributeFilter() {
        return this.withAttributeFilter;
    }

    Predicate<AttributeKey> getAttributeFilter() {
        return this.attributePredicate;
    }

    List<String> getHookList() {
        return this.hookList;
    }

    static ExportInclude parse(List<String> tokenList) {
        ArrayList<String> filterList = new ArrayList<String>();
        ArrayList<String> hookList = new ArrayList<String>();
        for (String token : tokenList) {
            if (token.startsWith("%")) {
                if ((token = token.substring(1)).length() <= 0) continue;
                hookList.add(token);
                continue;
            }
            filterList.add(token);
        }
        Predicate<AttributeKey> attributePredicate = !filterList.isEmpty() ? AttributeUtils.toAttributeKeyPredicate(filterList) : null;
        return new ExportInclude(attributePredicate, hookList);
    }
}

