/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.util.function.Consumer;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class FicheAttributesDOMReader {
    private final MessageHandler messageHandler;
    private final CorpusEditor corpusEditor;
    private final RootConsumer rootConsumer = new RootConsumer();

    public FicheAttributesDOMReader(CorpusEditor corpusEditor, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.corpusEditor = corpusEditor;
    }

    public void fillFicheMeta(FicheMeta ficheMeta, Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        this.rootConsumer.setFicheMeta(ficheMeta, attributesBuilder);
        DOMUtils.readChildren(element, this.rootConsumer);
        this.corpusEditor.getFichothequeEditor().putAttributes(ficheMeta, attributesBuilder.toAttributes());
    }

    private class RootConsumer
    implements Consumer<Element> {
        private FicheMeta ficheMeta;
        private AttributesBuilder attributesBuilder;

        private RootConsumer() {
        }

        private void setFicheMeta(FicheMeta ficheMeta, AttributesBuilder attributesBuilder) {
            this.ficheMeta = ficheMeta;
            this.attributesBuilder = attributesBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("attr")) {
                AttributeUtils.readAttrElement(this.attributesBuilder, element, FicheAttributesDOMReader.this.messageHandler, tagName);
            } else {
                DomMessages.unknownTagWarning(FicheAttributesDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

