/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.croisement;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.Lien;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.text.StringUtils;

public class CroisementChangeBuilder {
    private final Set<String> removedModeSet = new LinkedHashSet<String>();
    private final Map<String, Lien> lienMap = new LinkedHashMap<String, Lien>();

    public CroisementChangeBuilder addRemovedMode(String mode) {
        this.removedModeSet.add(mode);
        return this;
    }

    public CroisementChangeBuilder addLien(Lien lien) {
        this.lienMap.put(lien.getMode(), lien);
        return this;
    }

    public CroisementChange toCroisementChange() {
        return CroisementChangeBuilder.toCroisementChange(this.removedModeSet, this.lienMap.values());
    }

    public static CroisementChangeBuilder init() {
        return new CroisementChangeBuilder();
    }

    static CroisementChange toCroisementChange(Collection<String> removedModes, Collection<Lien> changedLiens) {
        List<String> removedModeArray = StringUtils.toList(removedModes);
        List<Lien> changedLienArray = CroisementUtils.wrap(changedLiens.toArray(new Lien[changedLiens.size()]));
        return new InternalCroisementChange(removedModeArray, changedLienArray);
    }

    private static class InternalCroisementChange
    implements CroisementChange {
        private final List<String> removedModeArray;
        private final List<Lien> changedLienArray;

        private InternalCroisementChange(List<String> removedModeArray, List<Lien> changedLienArray) {
            this.removedModeArray = removedModeArray;
            this.changedLienArray = changedLienArray;
        }

        @Override
        public List<String> getRemovedModeList() {
            return this.removedModeArray;
        }

        @Override
        public List<Lien> getChangedLienList() {
            return this.changedLienArray;
        }
    }
}

