/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.Comparators;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;

public class FicheDistribution {
    private static final Comparator COMPARATOR = new FicheInfoComparator();
    private final SortedMap<String, Group> groupMap = new TreeMap<String, Group>();

    FicheDistribution() {
    }

    void addFiche(String name, FicheMeta ficheMeta, Object groupingObject) {
        Group group = (Group)this.groupMap.get(name);
        if (group == null) {
            group = new Group(name);
            this.groupMap.put(name, group);
        }
        group.add(ficheMeta, groupingObject);
    }

    public List<Group> toGroupList() {
        return new ArrayList<Group>(this.groupMap.values());
    }

    private static int compareFicheMeta(FicheMeta fm1, FicheMeta fm2) {
        int id2;
        int comp = fm1.getSubsetKey().compareTo(fm2.getSubsetKey());
        if (comp != 0) {
            return comp;
        }
        int id1 = fm1.getId();
        if (id1 < (id2 = fm2.getId())) {
            return 1;
        }
        if (id1 > id2) {
            return -1;
        }
        return 0;
    }

    public static class Group {
        private final String name;
        private final SortedMap<Integer, Year> yearMap = new TreeMap<Integer, Year>();
        private final SortedMap<Lang, ByLang> langMap = new TreeMap<Lang, ByLang>();
        private final Year nullYear = new Year(null);

        private Group(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Year> toYearList() {
            ArrayList<Year> list = new ArrayList<Year>();
            list.addAll(this.yearMap.values());
            Collections.reverse(list);
            if (!this.nullYear.isEmpty()) {
                list.add(this.nullYear);
            }
            return list;
        }

        public List<ByLang> getByLangList() {
            ArrayList<ByLang> list = new ArrayList<ByLang>();
            list.addAll(this.langMap.values());
            return list;
        }

        private void add(FicheMeta ficheMeta, Object groupingObject) {
            if (groupingObject == null) {
                this.nullYear.addFicheMeta(ficheMeta, null);
            } else if (groupingObject instanceof FuzzyDate) {
                FuzzyDate fuzzyDate = (FuzzyDate)groupingObject;
                Integer yearNumber = fuzzyDate.getYear();
                Year year = (Year)this.yearMap.get(yearNumber);
                if (year == null) {
                    year = new Year(yearNumber);
                    this.yearMap.put(yearNumber, year);
                }
                year.addFicheMeta(ficheMeta, fuzzyDate);
            } else if (groupingObject instanceof Lang) {
                Lang lang = (Lang)groupingObject;
                ByLang byLang = (ByLang)this.langMap.get(lang);
                if (byLang == null) {
                    byLang = new ByLang(lang);
                    this.langMap.put(lang, byLang);
                }
                byLang.addFicheMeta(ficheMeta);
            }
        }
    }

    private static class FicheInfoComparator
    implements Comparator<FicheInfo> {
        private FicheInfoComparator() {
        }

        @Override
        public int compare(FicheInfo fi1, FicheInfo fi2) {
            FuzzyDate date1 = fi1.getFuzzyDate();
            FuzzyDate date2 = fi2.getFuzzyDate();
            if (date1 == null) {
                if (date2 == null) {
                    return FicheDistribution.compareFicheMeta(fi1.getFicheMeta(), fi2.getFicheMeta());
                }
                return 1;
            }
            if (date2 == null) {
                return -1;
            }
            int comp = date1.compareTo(date2);
            if (comp != 0) {
                return -comp;
            }
            return FicheDistribution.compareFicheMeta(fi1.getFicheMeta(), fi2.getFicheMeta());
        }
    }

    private static class TitleComparator
    implements Comparator<FicheInfo> {
        private final Comparator<FicheMeta> ficheMetaComparator;

        private TitleComparator(Comparator<FicheMeta> ficheMetaComparator) {
            this.ficheMetaComparator = ficheMetaComparator;
        }

        @Override
        public int compare(FicheInfo fi1, FicheInfo fi2) {
            int comp = this.ficheMetaComparator.compare(fi1.getFicheMeta(), fi2.getFicheMeta());
            if (comp != 0) {
                return comp;
            }
            return FicheDistribution.compareFicheMeta(fi1.getFicheMeta(), fi2.getFicheMeta());
        }
    }

    public static class FicheInfo {
        private final FicheMeta ficheMeta;
        private final FuzzyDate fuzzyDate;

        private FicheInfo(FicheMeta ficheMeta, FuzzyDate fuzzyDate) {
            this.ficheMeta = ficheMeta;
            this.fuzzyDate = fuzzyDate;
        }

        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        public FuzzyDate getFuzzyDate() {
            return this.fuzzyDate;
        }
    }

    public static class ByLang {
        private final Lang lang;
        private final Map<FicheMeta, FicheInfo> ficheInfoMap = new HashMap<FicheMeta, FicheInfo>();

        private ByLang(Lang lang) {
            this.lang = lang;
        }

        public Lang getLang() {
            return this.lang;
        }

        public List<FicheInfo> toFicheInfoList() {
            ArrayList<FicheInfo> infoList = new ArrayList<FicheInfo>(this.ficheInfoMap.values());
            Collator collator = Collator.getInstance(this.lang.toLocale());
            collator.setStrength(0);
            Collections.sort(infoList, new TitleComparator(Comparators.title(collator, false)));
            return infoList;
        }

        private void addFicheMeta(FicheMeta ficheMeta) {
            this.ficheInfoMap.put(ficheMeta, new FicheInfo(ficheMeta, ficheMeta.getCreationDate()));
        }
    }

    public static class Year {
        private final Integer yearInteger;
        private final Map<FicheMeta, FicheInfo> ficheInfoMap = new HashMap<FicheMeta, FicheInfo>();

        private Year(Integer yearInteger) {
            this.yearInteger = yearInteger;
        }

        private boolean isEmpty() {
            return this.ficheInfoMap.isEmpty();
        }

        public Integer getYearInteger() {
            return this.yearInteger;
        }

        public List<FicheInfo> toFicheInfoList() {
            ArrayList<FicheInfo> infoList = new ArrayList<FicheInfo>(this.ficheInfoMap.values());
            Collections.sort(infoList, COMPARATOR);
            return infoList;
        }

        private void addFicheMeta(FicheMeta ficheMeta, FuzzyDate date) {
            this.ficheInfoMap.put(ficheMeta, new FicheInfo(ficheMeta, date));
        }
    }
}

