/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.text.ParseException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.ExistingNameException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadata;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.fichotheque.impl.AbstractMetadata;
import net.fichotheque.impl.AlbumDataSource;
import net.fichotheque.impl.AlbumImpl;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

class AlbumMetadataImpl
extends AbstractMetadata
implements AlbumMetadata {
    private static final ResizeInfo MINI_RESIZEINFO = ResizeInfo.newMaxDimInstance(96, 64);
    private final AlbumImpl album;
    private final SortedMap<String, AlbumDimImpl> albumDimMap = new TreeMap<String, AlbumDimImpl>();
    private List<AlbumDim> cacheList;

    private AlbumMetadataImpl(AlbumImpl album) {
        this.album = album;
    }

    static InitEditor fromInit(AlbumImpl.InitEditor albumInitEditor) {
        AlbumMetadataImpl metadata = new AlbumMetadataImpl((AlbumImpl)albumInitEditor.getAlbum());
        return new InitEditor(metadata, albumInitEditor);
    }

    static AlbumMetadataImpl fromNew(AlbumImpl album) {
        return new AlbumMetadataImpl(album);
    }

    @Override
    public Album getAlbum() {
        return this.album;
    }

    @Override
    public List<AlbumDim> getAlbumDimList() {
        List<AlbumDim> result = this.cacheList;
        if (result == null) {
            result = this.initAlbumDimList();
        }
        return result;
    }

    @Override
    public AlbumDim getAlbumDimByName(String name) {
        return (AlbumDim)this.albumDimMap.get(name);
    }

    @Override
    public ResizeInfo getResizeInfo(short specialDim) {
        switch (specialDim) {
            case 201: {
                return MINI_RESIZEINFO;
            }
        }
        return null;
    }

    @Override
    protected void fireChange(FichothequeEditor fichothequeEditor) {
        AlbumImpl.AlbumEditorImpl albumEditor = (AlbumImpl.AlbumEditorImpl)fichothequeEditor.getAlbumEditor(this.album);
        albumEditor.setMetadataChange();
    }

    AlbumMetadataEditor getAlbumMetadataEditor(AlbumImpl.AlbumEditorImpl albumEditor) {
        return new AlbumMetadataEditorImpl(albumEditor);
    }

    boolean isFromAlbum(AlbumDim albumDim) {
        try {
            this.testAlbumDim(albumDim);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    void clear() {
        this.albumDimMap.clear();
        this.clearCache();
    }

    private AlbumDimImpl testAlbumDim(AlbumDim albumDim) throws IllegalArgumentException {
        if (!(albumDim instanceof AlbumDimImpl)) {
            throw new IllegalArgumentException("albumDim argument does not come from this AlbumMetadata instance");
        }
        if (albumDim.getAlbumMetadata() != this) {
            throw new IllegalArgumentException("albumDim argument does not come from this AlbumMetadata instance");
        }
        return (AlbumDimImpl)albumDim;
    }

    private synchronized AlbumDim innerCreateAlbumDim(String name, String type) throws ExistingNameException, ParseException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        if (this.albumDimMap.containsKey(name)) {
            throw new ExistingNameException();
        }
        AlbumUtils.testAlbumDimName(name);
        AlbumDimImpl bdfimplAlbumDim = new AlbumDimImpl(name, type);
        this.albumDimMap.put(name, bdfimplAlbumDim);
        this.clearCache();
        return bdfimplAlbumDim;
    }

    private synchronized boolean innerSetDim(AlbumDim albumDim, int width, int height) {
        AlbumDimImpl bdfimplAlbumDim = this.testAlbumDim(albumDim);
        boolean done = bdfimplAlbumDim.setDim(width, height);
        return done;
    }

    private synchronized boolean innerRemoveAlbumDim(AlbumDim albumDim) {
        AlbumDimImpl bdfimplAlbumDim = this.testAlbumDim(albumDim);
        String name = bdfimplAlbumDim.getName();
        if (!this.albumDimMap.containsKey(name)) {
            return false;
        }
        this.albumDimMap.remove(name);
        this.clearCache();
        return true;
    }

    private void clearCache() {
        this.cacheList = null;
    }

    private synchronized List<AlbumDim> initAlbumDimList() {
        List<AlbumDim> list = AlbumUtils.wrap(this.albumDimMap.values().toArray(new AlbumDim[this.albumDimMap.size()]));
        this.cacheList = list;
        return list;
    }

    private static ResizeInfo toResizeInfo(String type, int width, int height) {
        switch (type) {
            case "fixed-width": {
                return ResizeInfo.newFixedWidthInstance(width);
            }
            case "fixed-height": {
                return ResizeInfo.newFixedHeightInstance(height);
            }
            case "max-width": {
                return ResizeInfo.newMaxWidthInstance(width);
            }
            case "max-height": {
                return ResizeInfo.newMaxHeightInstance(height);
            }
            case "max-dim": {
                return ResizeInfo.newMaxDimInstance(width, height);
            }
        }
        throw new SwitchException("unknownType = " + type);
    }

    static /* synthetic */ ResizeInfo access$800() {
        return MINI_RESIZEINFO;
    }

    static class InitEditor
    implements AlbumMetadataEditor {
        private final AlbumMetadataImpl albumMetadata;
        private final AlbumEditor albumEditor;

        private InitEditor(AlbumMetadataImpl albumMetadata, AlbumEditor albumEditor) {
            this.albumMetadata = albumMetadata;
            this.albumEditor = albumEditor;
        }

        @Override
        public AlbumMetadata getAlbumMetadata() {
            return this.albumMetadata;
        }

        @Override
        public AlbumEditor getAlbumEditor() {
            return this.albumEditor;
        }

        @Override
        public AlbumDim createAlbumDim(String name, String type) throws ExistingNameException, ParseException {
            return this.albumMetadata.innerCreateAlbumDim(name, type);
        }

        @Override
        public boolean removeAlbumDim(AlbumDim albumDim) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean setDim(AlbumDim albumDim, int width, int height) {
            return this.albumMetadata.innerSetDim(albumDim, width, height);
        }

        @Override
        public Metadata getMetadata() {
            return this.albumMetadata;
        }

        @Override
        public boolean putLabel(String name, Label label) {
            return this.albumMetadata.innerPutLabel(name, label);
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            return this.albumMetadata.innerRemoveLabel(name, lang);
        }
    }

    private class AlbumMetadataEditorImpl
    implements AlbumMetadataEditor {
        private final AlbumImpl.AlbumEditorImpl albumEditor;

        private AlbumMetadataEditorImpl(AlbumImpl.AlbumEditorImpl albumEditor) {
            this.albumEditor = albumEditor;
        }

        @Override
        public AlbumMetadata getAlbumMetadata() {
            return AlbumMetadataImpl.this;
        }

        @Override
        public AlbumEditor getAlbumEditor() {
            return this.albumEditor;
        }

        @Override
        public AlbumDim createAlbumDim(String name, String type) throws ExistingNameException, ParseException {
            AlbumDim albumDim = AlbumMetadataImpl.this.innerCreateAlbumDim(name, type);
            this.fireChange();
            return albumDim;
        }

        @Override
        public boolean removeAlbumDim(AlbumDim albumDim) {
            String name = albumDim.getName();
            boolean done = AlbumMetadataImpl.this.innerRemoveAlbumDim(albumDim);
            if (done) {
                AlbumDataSource albumDataSource = ((FichothequeImpl)AlbumMetadataImpl.this.album.getFichotheque()).getFichothequeDataSource().getAlbumDataSource();
                albumDataSource.clearDimCache(AlbumMetadataImpl.this.album.getSubsetKey(), name);
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean setDim(AlbumDim albumDim, int width, int height) {
            boolean done = AlbumMetadataImpl.this.innerSetDim(albumDim, width, height);
            if (done) {
                AlbumDataSource albumDataSource = ((FichothequeImpl)AlbumMetadataImpl.this.album.getFichotheque()).getFichothequeDataSource().getAlbumDataSource();
                albumDataSource.clearDimCache(AlbumMetadataImpl.this.album.getSubsetKey(), albumDim.getName());
                this.fireChange();
            }
            return done;
        }

        @Override
        public Metadata getMetadata() {
            return AlbumMetadataImpl.this;
        }

        @Override
        public boolean putLabel(String name, Label label) {
            boolean done = AlbumMetadataImpl.this.innerPutLabel(name, label);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            boolean done = AlbumMetadataImpl.this.innerRemoveLabel(name, lang);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        private void fireChange() {
            this.albumEditor.setMetadataChange();
        }
    }

    private class AlbumDimImpl
    implements AlbumDim {
        private final String name;
        private final String type;
        private ResizeInfo resizeInfo = AlbumMetadataImpl.access$800();

        private AlbumDimImpl(String name, String type) {
            this.name = name;
            this.type = type;
            this.resizeInfo = AlbumMetadataImpl.toResizeInfo(type, 100, 100);
        }

        @Override
        public AlbumMetadata getAlbumMetadata() {
            return AlbumMetadataImpl.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDimType() {
            return this.type;
        }

        @Override
        public ResizeInfo getResizeInfo() {
            return this.resizeInfo;
        }

        private boolean setDim(int width, int height) {
            try {
                ResizeInfo newResizeInfo = AlbumMetadataImpl.toResizeInfo(this.type, width, height);
                if (newResizeInfo.equals(this.resizeInfo)) {
                    return false;
                }
                this.resizeInfo = newResizeInfo;
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }
}

