/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.text.StringUtils;

public final class SubsetKey
implements Comparable {
    private static final Map<String, SubsetKey> internMap = new HashMap<String, SubsetKey>();
    public static final short CATEGORY_CORPUS = 1;
    public static final short CATEGORY_THESAURUS = 2;
    public static final short CATEGORY_SPHERE = 3;
    public static final short CATEGORY_ADDENDA = 4;
    public static final short CATEGORY_ALBUM = 5;
    public static final String CATEGORY_CORPUS_STRING = "corpus";
    public static final String CATEGORY_THESAURUS_STRING = "thesaurus";
    public static final String CATEGORY_SPHERE_STRING = "sphere";
    public static final String CATEGORY_ADDENDA_STRING = "addenda";
    public static final String CATEGORY_ALBUM_STRING = "album";
    private final String subsetKeyString;
    private final String subsetName;
    private final short category;

    private SubsetKey(String subsetKeyString, short category, String subsetName) {
        this.category = category;
        this.subsetKeyString = subsetKeyString;
        this.subsetName = subsetName;
        SubsetKey.intern(this);
    }

    private static SubsetKey initSubsetKey(short category, String subsetName) {
        String subsetKeyString = SubsetKey.toKeyString(category, subsetName);
        SubsetKey current = internMap.get(subsetKeyString);
        if (current != null) {
            return current;
        }
        return new SubsetKey(subsetKeyString, category, subsetName);
    }

    private static synchronized void intern(SubsetKey subsetKey) {
        internMap.put(subsetKey.subsetKeyString, subsetKey);
    }

    private static String toKeyString(short category, String subsetName) {
        StringBuilder buf = new StringBuilder();
        buf.append(SubsetKey.categoryToString(category));
        buf.append("_");
        buf.append(subsetName);
        return buf.toString();
    }

    public static SubsetKey parse(short category, String subsetName) throws ParseException {
        if (category < 1 || category > 5) {
            throw new IllegalArgumentException("wrong category value");
        }
        StringUtils.checkTechnicalName(subsetName, false);
        return SubsetKey.initSubsetKey(category, subsetName);
    }

    public static SubsetKey parse(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("string null", 0);
        }
        SubsetKey current = internMap.get(s);
        if (current != null) {
            return current;
        }
        int idx = s.indexOf(95);
        if (idx == -1) {
            throw new ParseException("missing '_' character", s.length() - 1);
        }
        if (idx == 0) {
            throw new ParseException("starts with '_' character", 0);
        }
        if (idx == s.length() - 1) {
            throw new ParseException("ends with '_' character", s.length() - 1);
        }
        short category = 0;
        try {
            category = SubsetKey.categoryToShort(s.substring(0, idx));
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("wrong category string: " + s.substring(0, idx), idx - 1);
        }
        return SubsetKey.parse(category, s.substring(idx + 1));
    }

    public static SubsetKey build(short category, String subsetName) {
        try {
            return SubsetKey.parse(category, subsetName);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static SubsetKey build(String s) {
        try {
            return SubsetKey.parse(s);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static SubsetKey parseParentageSubsetKey(String s) throws ParseException {
        short category;
        if (s == null) {
            throw new ParseException("string null", 0);
        }
        int idx = s.indexOf(95);
        if (idx == -1) {
            throw new ParseException("missing '_' character", s.length() - 1);
        }
        if (idx == 0) {
            throw new ParseException("starts with '_' character", 0);
        }
        if (idx == s.length() - 1) {
            throw new ParseException("ends with '_' character", s.length() - 1);
        }
        String prefix = s.substring(0, idx);
        if (prefix.equals("fiche")) {
            category = 1;
        } else if (prefix.equals("motcle")) {
            category = 2;
        } else {
            throw new ParseException("wrong prefix string: " + prefix, 0);
        }
        return SubsetKey.parse(category, s.substring(idx + 1));
    }

    public String getSubsetName() {
        return this.subsetName;
    }

    public short getCategory() {
        return this.category;
    }

    public String getCategoryString() {
        return SubsetKey.categoryToString(this.category);
    }

    public int hashCode() {
        return this.subsetKeyString.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        SubsetKey otherSubsetKey = (SubsetKey)other;
        return otherSubsetKey.category == this.category && otherSubsetKey.subsetName.equals(this.subsetName);
    }

    public boolean isCorpusSubset() {
        if (this.category != 1) {
            return false;
        }
        return this.subsetName.length() != 1;
    }

    public boolean isThesaurusSubset() {
        if (this.category != 2) {
            return false;
        }
        return this.subsetName.length() != 1;
    }

    public boolean isSphereSubset() {
        if (this.category != 3) {
            return false;
        }
        return this.subsetName.length() != 1;
    }

    public boolean isAlbumSubset() {
        if (this.category != 5) {
            return false;
        }
        return this.subsetName.length() != 1;
    }

    public boolean isAddendaSubset() {
        return this.category == 4;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        SubsetKey other = (SubsetKey)obj;
        if (this.category < other.category) {
            return -1;
        }
        if (this.category > other.category) {
            return 1;
        }
        if (this.subsetName.length() == 1) {
            if (other.subsetName.length() == 1) {
                return this.subsetName.compareTo(other.subsetName);
            }
            return -1;
        }
        if (other.subsetName.length() == 1) {
            return 1;
        }
        return this.subsetName.compareTo(other.subsetName);
    }

    public String getKeyString() {
        return this.subsetKeyString;
    }

    public String toString() {
        return this.subsetKeyString;
    }

    public static String categoryToString(short subsetCategory) {
        switch (subsetCategory) {
            case 1: {
                return CATEGORY_CORPUS_STRING;
            }
            case 2: {
                return CATEGORY_THESAURUS_STRING;
            }
            case 3: {
                return CATEGORY_SPHERE_STRING;
            }
            case 4: {
                return CATEGORY_ADDENDA_STRING;
            }
            case 5: {
                return CATEGORY_ALBUM_STRING;
            }
        }
        throw new IllegalArgumentException("wrong croisementCategory value");
    }

    public static short categoryToShort(String s) {
        if (s.equals(CATEGORY_CORPUS_STRING)) {
            return 1;
        }
        if (s.equals(CATEGORY_THESAURUS_STRING)) {
            return 2;
        }
        if (s.equals(CATEGORY_SPHERE_STRING)) {
            return 3;
        }
        if (s.equals(CATEGORY_ADDENDA_STRING) || s.equals("document")) {
            return 4;
        }
        if (s.equals(CATEGORY_ALBUM_STRING)) {
            return 5;
        }
        throw new IllegalArgumentException("Wrong category string");
    }

    public static String toParentageString(SubsetKey subsetKey) {
        if (subsetKey.isCorpusSubset()) {
            return "fiche_" + subsetKey.getSubsetName();
        }
        if (subsetKey.isThesaurusSubset()) {
            return "motcle_" + subsetKey.getSubsetName();
        }
        throw new IllegalArgumentException("wrong subsetKey type: " + subsetKey);
    }
}

