/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.localisation.Lang;

public final class TreeUtils {
    public static final SubsetTree EMPTY_SUBSETTREE = new EmptySubsetTree();
    public static final List<SubsetTree.Node> EMPTY_NODELIST = Collections.emptyList();

    private TreeUtils() {
    }

    public static String getTitle(BdfServer bdfServer, GroupNode groupNode, Lang lang) {
        String name = groupNode.getName();
        GroupDef groupDef = bdfServer.getGroupManager().getGroupDef(name);
        if (groupDef != null) {
            return groupDef.getTitle(lang);
        }
        return name;
    }

    public static List<SubsetKey> getCorpusKeyList(BdfServer bdfServer) {
        return TreeUtils.toList(bdfServer.getTreeManager().getSubsetTree((short)1));
    }

    public static List<SubsetKey> toList(SubsetTree subsetTree) {
        ArrayList<SubsetKey> subsetKeyList = new ArrayList<SubsetKey>();
        TreeUtils.add(subsetKeyList, subsetTree.getNodeList());
        return subsetKeyList;
    }

    private static void add(List<SubsetKey> subsetKeyList, List<SubsetTree.Node> nodeList) {
        for (SubsetTree.Node node : nodeList) {
            if (node instanceof GroupNode) {
                TreeUtils.add(subsetKeyList, ((GroupNode)node).getSubnodeList());
                continue;
            }
            if (!(node instanceof SubsetNode)) continue;
            subsetKeyList.add(((SubsetNode)node).getSubsetKey());
        }
    }

    public static int size(SubsetTree subsetTree) {
        return TreeUtils.size(subsetTree.getNodeList());
    }

    public static int size(GroupNode groupNode) {
        return TreeUtils.size(groupNode.getSubnodeList());
    }

    private static int size(List<SubsetTree.Node> nodeList) {
        int size = 0;
        for (SubsetTree.Node node : nodeList) {
            if (node instanceof GroupNode) {
                size += TreeUtils.size((GroupNode)node);
                continue;
            }
            if (!(node instanceof SubsetNode)) continue;
            ++size;
        }
        return size;
    }

    public static SubsetKey getFirstSubsetKey(SubsetTree subsetTree) {
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof GroupNode) {
                SubsetKey result = TreeUtils.checkFirstSubset((GroupNode)node);
                if (result == null) continue;
                return result;
            }
            if (!(node instanceof SubsetNode)) continue;
            return ((SubsetNode)node).getSubsetKey();
        }
        return null;
    }

    private static SubsetKey checkFirstSubset(GroupNode groupNode) {
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            if (subnode instanceof GroupNode) {
                SubsetKey result = TreeUtils.checkFirstSubset((GroupNode)subnode);
                if (result == null) continue;
                return result;
            }
            if (!(subnode instanceof SubsetNode)) continue;
            return ((SubsetNode)subnode).getSubsetKey();
        }
        return null;
    }

    public static boolean containsSubsetKey(SubsetTree subsetTree, SubsetKey subsetKey) {
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            boolean result;
            if (!(node instanceof GroupNode ? (result = TreeUtils.containsSubsetKey((GroupNode)node, subsetKey)) : node instanceof SubsetNode && ((SubsetNode)node).getSubsetKey().equals(subsetKey))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSubsetKey(GroupNode groupNode, SubsetKey subsetKey) {
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            boolean result;
            if (!(subnode instanceof GroupNode ? (result = TreeUtils.containsSubsetKey((GroupNode)subnode, subsetKey)) : subnode instanceof SubsetNode && ((SubsetNode)subnode).getSubsetKey().equals(subsetKey))) continue;
            return true;
        }
        return false;
    }

    public static List<SubsetTree.Node> wrap(SubsetTree.Node[] array) {
        return new NodeList(array);
    }

    public static String toString(SubsetTree subsetTree) {
        StringBuilder buf = new StringBuilder();
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                TreeUtils.appendSubsetNode(buf, (SubsetNode)node, 0);
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            TreeUtils.appendGroupNode(buf, (GroupNode)node, 1);
        }
        return buf.toString();
    }

    private static void appendSubsetNode(StringBuilder buf, SubsetNode subsetNode, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append("  ");
        }
        buf.append(subsetNode.getSubsetKey());
        buf.append("\n");
    }

    private static void appendGroupNode(StringBuilder buf, GroupNode groupNode, int level) {
        int i;
        int i2;
        buf.append("\n");
        String name = groupNode.getName();
        for (i2 = 0; i2 < level - 1; ++i2) {
            buf.append("  ");
        }
        for (i2 = 0; i2 < level; ++i2) {
            buf.append('+');
        }
        buf.append(" ");
        buf.append(name);
        buf.append("\n");
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            if (subnode instanceof SubsetNode) {
                TreeUtils.appendSubsetNode(buf, (SubsetNode)subnode, level + 1);
                continue;
            }
            if (!(subnode instanceof GroupNode)) continue;
            TreeUtils.appendGroupNode(buf, (GroupNode)subnode, level + 1);
        }
        for (i = 0; i < level - 1; ++i) {
            buf.append("  ");
        }
        for (i = 0; i < level; ++i) {
            buf.append('-');
        }
        buf.append(" ");
        buf.append(name);
        buf.append("\n\n");
    }

    private static class NodeList
    extends AbstractList<SubsetTree.Node>
    implements RandomAccess {
        private final SubsetTree.Node[] array;

        private NodeList(SubsetTree.Node[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SubsetTree.Node get(int index) {
            return this.array[index];
        }
    }

    private static class EmptySubsetTree
    implements SubsetTree {
        private EmptySubsetTree() {
        }

        @Override
        public List<SubsetTree.Node> getNodeList() {
            return EMPTY_NODELIST;
        }
    }
}

