/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class StorageUnitBuilder {
    private final Map<String, StorageContent> storageContentMap;

    protected StorageUnitBuilder(boolean sort) {
        this.storageContentMap = sort ? new TreeMap<String, StorageContent>() : new LinkedHashMap<String, StorageContent>();
    }

    public StorageUnitBuilder addStorageContent(StorageContent storageContent) {
        this.storageContentMap.put(storageContent.getPath(), storageContent);
        return this;
    }

    public StorageUnitBuilder addStorageContent(String path, File file) {
        return this.addStorageContent(StorageUtils.toStorageContent(path, file));
    }

    public StorageUnitBuilder addStorageContent(String path, String text) {
        this.storageContentMap.put(path, StorageUtils.toStorageContent(path, text));
        return this;
    }

    public StorageUnitBuilder addStorageContent(String path, byte[] array) {
        this.storageContentMap.put(path, StorageUtils.toStorageContent(path, array));
        return this;
    }

    public StorageUnitBuilder populate(File dir, String pathRoot) {
        String path = pathRoot + dir.getName() + "/";
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.populate(f, path);
                continue;
            }
            String filePath = path + f.getName();
            this.addStorageContent(filePath, f);
        }
        return this;
    }

    public List<StorageContent> toStorageContentList() {
        return StorageUtils.wrap(this.storageContentMap.values().toArray(new StorageContent[this.storageContentMap.size()]));
    }
}

