/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.groups;

import fr.exemole.bdfserver.api.groups.GroupDef;
import java.text.ParseException;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;

public class GroupDefBuilder
extends DefBuilder {
    private final String name;

    public GroupDefBuilder(String name) {
        try {
            GroupDef.checkGroupName(name);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Not a  valid group name: " + name);
        }
        this.name = name;
    }

    public GroupDef toGroupDef() {
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        return new InternalGroupDef(this.name, titleLabels, attributes);
    }

    public static GroupDefBuilder init(String name) {
        return new GroupDefBuilder(name);
    }

    private static class InternalGroupDef
    implements GroupDef {
        private final String name;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalGroupDef(String name, Labels titleLabels, Attributes attributes) {
            this.name = name;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

