/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.ItemFieldElement;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class ItemFieldElementBuilder {
    private final CorpusField corpusField;
    private String label = "";
    private boolean mandatory;
    private String value = "";
    private boolean redimAllowed;
    private int rows;
    private String widthType;
    private SubsetKey sphereKey;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public ItemFieldElementBuilder(CorpusField corpusField) {
        this.corpusField = corpusField;
    }

    public ItemFieldElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public ItemFieldElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public ItemFieldElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public ItemFieldElementBuilder setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = value;
        return this;
    }

    public ItemFieldElementBuilder setRedimAllowed(boolean redimAllowed) {
        this.redimAllowed = redimAllowed;
        return this;
    }

    public ItemFieldElementBuilder setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public ItemFieldElementBuilder setWidthType(String widthType) {
        this.widthType = widthType;
        return this;
    }

    public ItemFieldElementBuilder setSphereKey(SubsetKey sphereKey) {
        this.sphereKey = sphereKey;
        return this;
    }

    public ItemFieldElement toItemFieldElement() {
        return new InternalItemFieldElement(this.corpusField, this.label, this.mandatory, this.attributes, this.value, this.redimAllowed, this.rows, this.widthType, this.sphereKey);
    }

    public static ItemFieldElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi, @Nullable String defaultValue) {
        Redacteur defaultRedacteur;
        boolean redimAllowed = ItemFieldElementBuilder.getDefaultRedimAllowed(corpusField);
        String value = fichePointeur.isEmpty() ? (defaultValue != null ? defaultValue : FicheFormUtils.getDefVal(fichePointeur, ficheFormParameters, fieldUi)) : FicheFormUtils.getStringValue(fichePointeur, corpusField, ficheFormParameters);
        int rows = FicheFormUtils.checkRows(fieldUi, redimAllowed ? value.length() : -1);
        if (rows == 1 && corpusField.isBlockDisplayInfoField()) {
            rows = 3;
        }
        SubsetKey defaultSphereKey = null;
        if (corpusField.isType("person") && (defaultSphereKey = corpusField.getDefaultSphereKey()) == null && (defaultRedacteur = ficheFormParameters.getDefaultRedacteur()) != null) {
            defaultSphereKey = defaultRedacteur.getSubsetKey();
        }
        if (value.isEmpty() && fieldUi.isObsolete()) {
            return null;
        }
        return ItemFieldElementBuilder.init(corpusField).setRedimAllowed(redimAllowed).setValue(value).setRows(rows).setSphereKey(defaultSphereKey).setMandatory(fieldUi.isMandatory()).setAttributes(fieldUi.getAttributes()).setLabel(L10nUtils.toLabelString(ficheFormParameters, corpusField)).setWidthType(FicheFormUtils.getWidth(fieldUi));
    }

    public static ItemFieldElementBuilder init(CorpusField corpusField) {
        return new ItemFieldElementBuilder(corpusField);
    }

    private static boolean getDefaultRedimAllowed(CorpusField corpusField) {
        if (!corpusField.isProp()) {
            return true;
        }
        switch (corpusField.getFicheItemType()) {
            case "item": 
            case "para": {
                return true;
            }
        }
        return false;
    }

    private static class InternalItemFieldElement
    implements ItemFieldElement {
        private final CorpusField corpusField;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final String value;
        private final boolean redimAllowed;
        private final int rows;
        private final String widthType;
        private final SubsetKey sphereKey;

        private InternalItemFieldElement(CorpusField corpusField, String label, boolean mandatory, Attributes attributes, String value, boolean redimAllowed, int rows, String widthType, SubsetKey sphereKey) {
            this.corpusField = corpusField;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.value = value;
            this.redimAllowed = redimAllowed;
            this.rows = rows;
            this.widthType = widthType;
            this.sphereKey = sphereKey;
        }

        @Override
        public CorpusField getCorpusField() {
            return this.corpusField;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isRedimAllowed() {
            return this.redimAllowed;
        }

        @Override
        public int getRows() {
            return this.rows;
        }

        @Override
        public String getWidthType() {
            return this.widthType;
        }

        @Override
        public SubsetKey getSphereKey() {
            return this.sphereKey;
        }
    }
}

