/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.externalsource;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.externalsource.ExternalSourceType;
import fr.exemole.bdfserver.api.externalsource.FichothequeSharing;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceTypeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.thesaurus.Thesaurus;

public class CoreExternalSourceCatalog {
    public static final String FICHOTHEQUECORPUS_TYPENAME = "fichothequecorpus";
    public static final String WIKIDATA_TYPENAME = "wikidata";
    public static final String DATAUI_FICHES_TYPENAME = "fiches";
    public static final ExternalSourceType FICHOTHEQUECORPUS = ExternalSourceTypeBuilder.init("fichothequecorpus").setL10nObject("_ title.external.fichothequecorpus").addParam("fichotheque", "_ label.external.fichotheque").addParam("corpus", "_ label.external.fichothequecorpus_corpus").toExternalSourceType();
    public static final ExternalSourceType WIKIDATA = ExternalSourceTypeBuilder.init("wikidata").setL10nObject("_ title.external.wikidata").toExternalSourceType();
    public static final ExternalSourceType DATAUI_FICHES = ExternalSourceTypeBuilder.init("fiches").setL10nObject("_ label.external.dataui_fiches").addParam("fichotheque", "_ label.external.fichotheque").addParam("matchingthesaurus", "_ label.external.matchingthesaurus").addParam("corpus", "_ label.external.fiches_corpus").toExternalSourceType();
    private final BdfServer bdfServer;
    private final boolean withFichothequeSharing;
    private final FichothequeSharing fichothequeSharing;

    public CoreExternalSourceCatalog(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        this.fichothequeSharing = (FichothequeSharing)bdfServer.getContextObject("fichothequeSharing");
        this.withFichothequeSharing = this.fichothequeSharing != null;
    }

    public List<ExternalSourceType> getAvalaibleTypeList(Thesaurus thesaurus) {
        ArrayList<ExternalSourceType> result = new ArrayList<ExternalSourceType>();
        short thesaurusType = thesaurus.getThesaurusMetadata().getThesaurusType();
        if (thesaurusType == 3) {
            if (this.withFichothequeSharing) {
                result.add(FICHOTHEQUECORPUS);
            }
        } else if (thesaurusType == 2) {
            result.add(WIKIDATA);
        }
        return result;
    }

    public List<ExternalSourceType> getDataUiAvalaibleTypeList() {
        ArrayList<ExternalSourceType> result = new ArrayList<ExternalSourceType>();
        result.add(DATAUI_FICHES);
        return result;
    }

    public static ExternalSourceType getExternalSourceType(String typeName) {
        switch (typeName) {
            case "fichothequecorpus": {
                return FICHOTHEQUECORPUS;
            }
            case "wikidata": {
                return WIKIDATA;
            }
            case "fiches": {
                return DATAUI_FICHES;
            }
        }
        return null;
    }
}

