/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.BalayageTemplate;
import fr.exemole.bdfserver.api.balayage.FileGenerationListener;
import fr.exemole.bdfserver.api.balayage.TemplateProvider;
import fr.exemole.bdfserver.tools.balayage.TemplateProviderBuilder;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.EngineUtils;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractOutputRunner;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.mapeadores.util.io.BufferErrorListener;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.text.ValueResolver;
import net.mapeadores.util.xml.json.XmlToJson;

public class TransformOutputRunner
extends AbstractOutputRunner {
    private final BalayageUnit balayageUnit;
    private final FileGenerationListener fileGenerationListener;
    private final BalayageDef balayageDef;
    private String langOption = "";
    private String[] langArray;
    private TemplateProvider templateProvider;
    private Transformer posttransformTransformer;

    public TransformOutputRunner(BalayageParameters balayageParameters, int outputIndex, BalayageOutput output, int balayageUnitIndex) {
        super(balayageParameters, outputIndex, output, balayageUnitIndex);
        this.balayageUnit = output.getBalayageUnit();
        BdfServer bdfServer = balayageParameters.getBdfServer();
        this.balayageDef = balayageParameters.getBalayageDef();
        this.fileGenerationListener = balayageParameters.getFileGenerationListener();
        this.initLangArray();
        this.langOption = output.getLangOption();
        if (this.langOption.equals("")) {
            this.langOption = this.balayageDef.getDefaultLangOption();
        }
        if (!this.balayageDef.ignoreTransformation()) {
            String posttransform;
            InternalTemplateProviderBuilderErrorHandler transformerBuilderErrorHandler = new InternalTemplateProviderBuilderErrorHandler();
            TemplateProviderBuilder templateProviderBuilder = new TemplateProviderBuilder(bdfServer, balayageParameters.getPathConfiguration(), this.balayageDef, transformerBuilderErrorHandler);
            templateProviderBuilder.setCustomURIResolver(balayageParameters.getCustomURIResolver());
            this.templateProvider = templateProviderBuilder.build(output);
            if (this.templateProvider != null) {
                File balayageRootDirectory = balayageParameters.getBalayageRootDirectory();
                String absolutePath = balayageRootDirectory.getAbsolutePath();
                if (!absolutePath.endsWith(File.separator)) {
                    absolutePath = absolutePath + File.separator;
                }
                this.templateProvider.setBalayageRoot(absolutePath);
            }
            if (!(posttransform = output.getPosttransform()).isEmpty()) {
                this.posttransformTransformer = XmlToJson.newTransformer(posttransform);
            }
        }
    }

    private void initLangArray() {
        Langs langs = this.output.getCustomLangs();
        if (langs != null) {
            this.langArray = langs.toStringArray();
        } else {
            LangContext langContext = this.balayageParameters.getExtractParameters().getExtractionContext().getLangContext();
            if (langContext instanceof ListLangContext) {
                ListLangContext listLangContext = (ListLangContext)langContext;
                int langSize = listLangContext.size();
                this.langArray = new String[langSize];
                for (int i = 0; i < langSize; ++i) {
                    this.langArray[i] = ((ListLangContext.Unit)listLangContext.get(i)).getLang().toString();
                }
            } else if (langContext instanceof UserLangContext) {
                UserLangContext userLangContext = (UserLangContext)langContext;
                this.langArray = new String[1];
                this.langArray[0] = userLangContext.getWorkingLang().toString();
            } else {
                this.langArray = new String[0];
            }
        }
    }

    public void write(Object extractionObject, ValueResolver valueResolver, String extractionString) {
        if (this.balayageDef.ignoreTransformation() && !(extractionString instanceof String)) {
            throw new IllegalStateException("withTransformation may  be false only if extractionResult is an instance of String");
        }
        String fileName = EngineUtils.getFileName(this.output, valueResolver, this.output.getBalayageUnit().getType(), !this.balayageDef.ignoreTransformation());
        String path = EngineUtils.getPath(this.output, valueResolver);
        if (this.langOption.equals("none")) {
            this.write(extractionObject, fileName, path, this.langArray[0], extractionString);
        } else {
            for (String lang : this.langArray) {
                this.write(extractionObject, fileName, path, lang, extractionString);
            }
        }
    }

    private void write(Object extractionObject, String fileName, String path, String lang, String extractionString) {
        boolean done;
        File directory = this.rootDirectory;
        if (this.langOption.equals("dir")) {
            directory = new File(directory, lang);
        }
        if (path != null) {
            directory = new File(directory, path);
        }
        this.prepareDirectory(directory);
        File file = new File(directory, fileName);
        if (this.templateProvider != null) {
            this.templateProvider.setCurrentFileName(fileName);
            this.templateProvider.setCurrentLang(lang);
            this.templateProvider.setCurrentPath(path);
            done = this.writeTransformation(extractionObject, file, extractionString);
        } else {
            done = this.writeXml(file, extractionString);
        }
        if (done) {
            if (this.fileGenerationListener != null) {
                this.fileGenerationListener.generateFile(lang, path, fileName);
            }
            this.balayageLog.addFileGeneration(this.balayageUnitIndex, this.outputIndex, file);
        }
    }

    boolean writeXml(File file, String extractionString) {
        boolean bl;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(extractionString);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                String message = ioe.getClass().getName();
                if (msg != null) {
                    message = message + " : " + msg;
                }
                this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "ioException", file.getName(), message);
                return false;
            }
        }
        ((Writer)writer).close();
        return bl;
    }

    private boolean writeTransformation(Object extractionObject, File file, String extractionString) {
        boolean bl;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ByteArrayOutputStream bufOuputStream;
            OutputStream outputStream;
            if (this.posttransformTransformer == null) {
                outputStream = os;
                bufOuputStream = null;
            } else {
                bufOuputStream = new ByteArrayOutputStream();
                outputStream = bufOuputStream;
            }
            BalayageTemplate balayageTemplate = this.templateProvider.getBalayageTemplate(extractionObject);
            balayageTemplate.transform(extractionString, outputStream);
            if (this.posttransformTransformer != null) {
                StreamSource source = new StreamSource(new ByteArrayInputStream(bufOuputStream.toByteArray()));
                this.posttransformTransformer.transform(source, new StreamResult(os));
            }
            bl = true;
        }
        catch (Throwable outputStream) {
            try {
                try {
                    ((OutputStream)os).close();
                }
                catch (Throwable bufOuputStream) {
                    outputStream.addSuppressed(bufOuputStream);
                }
                throw outputStream;
            }
            catch (Exception e) {
                Throwable throwable = this.getCause(e);
                String msg = throwable.getMessage();
                String message = throwable.getClass().getName();
                if (msg != null) {
                    message = message + " : " + msg;
                }
                this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "transformerExceptionDuringTransformation", file.getName(), message);
                return false;
            }
        }
        ((OutputStream)os).close();
        return bl;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.templateProvider = null;
        this.langArray = null;
    }

    private Throwable getCause(Throwable e) {
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return e;
        }
        return this.getCause(throwable);
    }

    private class InternalTemplateProviderBuilderErrorHandler
    implements TemplateProviderBuilder.ErrorHandler {
        private InternalTemplateProviderBuilderErrorHandler() {
        }

        @Override
        public void transformerError(String xsltPath, BufferErrorListener errorListener) {
            TransformOutputRunner.this.isValid = false;
            TransformOutputRunner.this.balayageLog.addOutputError(TransformOutputRunner.this.balayageUnitIndex, TransformOutputRunner.this.outputIndex, TransformOutputRunner.this.output, "transformerException", xsltPath, errorListener.getErrorMessage());
        }

        @Override
        public void wrongXslPath(String xsltPath) {
            TransformOutputRunner.this.balayageLog.addBalayageUnitError(TransformOutputRunner.this.balayageUnitIndex, TransformOutputRunner.this.balayageUnit, "transformerNotFound", xsltPath, null);
            TransformOutputRunner.this.isValid = false;
        }

        @Override
        public void undefinedXslPath() {
            TransformOutputRunner.this.balayageLog.addOutputError(TransformOutputRunner.this.balayageUnitIndex, TransformOutputRunner.this.outputIndex, TransformOutputRunner.this.output, "noXsltPath", null, null);
            TransformOutputRunner.this.isValid = false;
        }

        @Override
        public void wrongBalayageUnitType() {
        }
    }
}

