/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.apps;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.text.RelativePath;

public final class AppConfUtils {
    private AppConfUtils() {
    }

    public static boolean isAvailableStarter(String starterName) {
        switch (starterName) {
            case "minimal": 
            case "dashboard": {
                return true;
            }
        }
        return false;
    }

    public static RelativePath getAppIniPath(String appName) throws ParseException {
        return StorageUtils.parseAppResourcePath(appName, "app.ini");
    }

    public static RelativePath getCustomIniPath(String appName) throws ParseException {
        return RelativePath.build("custom/app-" + appName + ".ini");
    }

    public static AppConf getAppConf(ResourceStorages resourceStorages, String appName) {
        RelativePath appIniPath;
        try {
            appIniPath = AppConfUtils.getAppIniPath(appName);
        }
        catch (ParseException pe) {
            return null;
        }
        if (!resourceStorages.containsResource(appIniPath)) {
            return null;
        }
        HashMap<String, String> iniMap = new HashMap<String, String>();
        AppConfUtils.parseIni(resourceStorages, appIniPath, iniMap);
        try {
            RelativePath customIniPath = AppConfUtils.getCustomIniPath(appName);
            AppConfUtils.parseIni(resourceStorages, customIniPath, iniMap);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new AppConf(appName, iniMap);
    }

    private static void parseIni(ResourceStorages resourceStorages, RelativePath relativePath, Map<String, String> iniMap) {
        DocStream docStream = resourceStorages.getResourceDocStream(relativePath);
        if (docStream != null) {
            try (InputStream is = docStream.getInputStream();){
                IniParser.parseIni(is, iniMap);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }

    public static SortedMap<String, AppConf> getAppConfList(ResourceStorages resourceStorages) {
        TreeMap<String, AppConf> result = new TreeMap<String, AppConf>();
        for (ResourceStorage resourceStorage : resourceStorages) {
            ResourceFolder appsFolder = resourceStorage.getResourceFolder(StorageUtils.APPS_ROOT);
            if (appsFolder == null) continue;
            for (ResourceFolder subfolder : appsFolder.getSubfolderList()) {
                AppConf appConf;
                String name = subfolder.getName();
                if (result.containsKey(name) || (appConf = AppConfUtils.getAppConf(resourceStorages, name)) == null) continue;
                result.put(name, appConf);
            }
        }
        return result;
    }
}

