/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.menu.ActionGroup;
import fr.exemole.bdfserver.api.menu.MenuGroup;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.api.providers.ActionProvider;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.api.providers.HookHandlerProvider;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.api.providers.JsonProducerProvider;
import fr.exemole.bdfserver.api.providers.MenuLinkProvider;
import fr.exemole.bdfserver.api.providers.StreamProducerProvider;
import fr.exemole.bdfserver.api.roles.SatelliteOpportunities;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.dataresolvers.ErrorDataResolver;
import fr.exemole.bdfserver.tools.dataresolvers.FichesDataResolver;
import fr.exemole.bdfserver.tools.dataresolvers.ResolverErrorException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.HtmlConverter;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.extraction.DataKey;
import net.fichotheque.extraction.DataResolver;
import net.fichotheque.extraction.DataResolverProvider;
import net.fichotheque.extraction.ExtensionDataResolverProvider;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.selection.SelectionOptions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.extraction.ExtractionContextUtils;
import net.fichotheque.tools.extraction.builders.ExtractionContextBuilder;
import net.fichotheque.tools.from.html.ConversionEngine;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.tools.selection.FichothequeQueriesBuilder;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.opendocument.css.parse.CssErrorHandler;
import net.mapeadores.opendocument.css.parse.CssParser;
import net.mapeadores.opendocument.css.parse.CssSource;
import net.mapeadores.opendocument.css.parse.LogCssErrorHandler;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.hook.HookHandler;
import net.mapeadores.util.hook.MultiHookHandlerBuilder;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.jsoup.HtmlCleaners;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.ListLangContextBuilder;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.RelativePath;

public final class BdfServerUtils {
    public static final HtmlCleaner DEFAULT_HTMLCLEANER = HtmlCleaners.WELLFORMED;
    public static final HtmlConverter DEFAULT_HTMLCONVERTER = new DefaultHtmlConverter();
    private static final SatelliteOpportunities EMPTY_SATELLITEOPPORTUNITIES = new EmptySatelliteOpportunities();

    private BdfServerUtils() {
    }

    public static Lang checkLangDisponibility(BdfServer bdfServer, Thesaurus thesaurus, Lang lang) {
        return ThesaurusUtils.checkDisponibility(bdfServer.getThesaurusLangChecker(), thesaurus, lang);
    }

    public static String getMillier(int id) {
        if (id < 1000) {
            return "000";
        }
        StringBuilder buf = new StringBuilder();
        if (id < 10000) {
            buf.append("00");
        } else if (id < 100000) {
            buf.append("0");
        }
        buf.append(id / 1000);
        return buf.toString();
    }

    public static boolean changeLabels(BdfServerEditor bdfServerEditor, Object labelHolder, LabelChange labelChange) {
        boolean stepdone;
        boolean done = false;
        for (Label label : labelChange.getChangedLabels()) {
            stepdone = bdfServerEditor.putLabel(labelHolder, label);
            if (!stepdone) continue;
            done = true;
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            stepdone = bdfServerEditor.removeLabel(labelHolder, lang);
            if (!stepdone) continue;
            done = true;
        }
        return done;
    }

    public static boolean changeAttributes(BdfServerEditor bdfServerEditor, Object attributesHolder, AttributeChange attributeChange) {
        boolean stepdone;
        boolean done = false;
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            stepdone = bdfServerEditor.putAttribute(attributesHolder, attribute);
            if (!stepdone) continue;
            done = true;
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            stepdone = bdfServerEditor.removeAttribute(attributesHolder, removedAttributeKey);
            if (!stepdone) continue;
            done = true;
        }
        return done;
    }

    public static SatelliteOpportunities getSatelliteOpportunities(SubsetItem masterSubsetItem, PermissionSummary permissionSummary) {
        Subset masterSubset = masterSubsetItem.getSubset();
        List<Corpus> satelliteCorpusList = masterSubset.getSatelliteCorpusList();
        if (satelliteCorpusList.isEmpty()) {
            return EMPTY_SATELLITEOPPORTUNITIES;
        }
        int masterId = masterSubsetItem.getId();
        ArrayList<InternalOpportunity> opportunityList = new ArrayList<InternalOpportunity>();
        boolean onlyReadAllowed = true;
        for (Corpus satelliteCorpus : satelliteCorpusList) {
            FicheMeta otherFicheMeta = satelliteCorpus.getFicheMetaById(masterId);
            if (otherFicheMeta == null) {
                if (!permissionSummary.canCreate(satelliteCorpus)) continue;
                onlyReadAllowed = false;
                opportunityList.add(new InternalOpportunity(satelliteCorpus, 1));
                continue;
            }
            if (permissionSummary.canWrite(otherFicheMeta)) {
                opportunityList.add(new InternalOpportunity(otherFicheMeta, 2));
                onlyReadAllowed = false;
                continue;
            }
            if (!permissionSummary.canRead(otherFicheMeta)) continue;
            opportunityList.add(new InternalOpportunity(otherFicheMeta, 3));
        }
        SatelliteOpportunitiesEntryList entryList = new SatelliteOpportunitiesEntryList(opportunityList.toArray(new SatelliteOpportunities.Entry[opportunityList.size()]));
        return new InternalSatelliteOpportunities(entryList, onlyReadAllowed);
    }

    public static SatelliteOpportunities getSatelliteOpportunities(SubsetItem masterSubsetItem, PermissionSummary permissionSummary, Corpus[] corpusArray) {
        int masterId = masterSubsetItem.getId();
        ArrayList<InternalOpportunity> opportunityList = new ArrayList<InternalOpportunity>();
        boolean onlyReadAllowed = true;
        for (Corpus satelliteCorpus : corpusArray) {
            FicheMeta otherFicheMeta = satelliteCorpus.getFicheMetaById(masterId);
            if (otherFicheMeta == null) {
                if (!permissionSummary.canCreate(satelliteCorpus)) continue;
                onlyReadAllowed = false;
                opportunityList.add(new InternalOpportunity(satelliteCorpus, 1));
                continue;
            }
            if (permissionSummary.canWrite(otherFicheMeta)) {
                opportunityList.add(new InternalOpportunity(otherFicheMeta, 2));
                onlyReadAllowed = false;
                continue;
            }
            if (!permissionSummary.canRead(otherFicheMeta)) continue;
            opportunityList.add(new InternalOpportunity(otherFicheMeta, 3));
        }
        SatelliteOpportunitiesEntryList entryList = new SatelliteOpportunitiesEntryList(opportunityList.toArray(new SatelliteOpportunities.Entry[opportunityList.size()]));
        return new InternalSatelliteOpportunities(entryList, onlyReadAllowed);
    }

    public static OdsOptions buildOdsOptions(BdfServer bdfServer, String absoluteUri) {
        LogCssErrorHandler logCssErrorHandler = new LogCssErrorHandler();
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(bdfServer);
        ElementMaps elementMaps = BdfServerUtils.parseCss(bdfServer, pathConfiguration, absoluteUri, logCssErrorHandler);
        return OdsOptions.init().elementMaps(elementMaps).odLog(logCssErrorHandler);
    }

    public static OdsOptions buildOdsOptions(ResourceStorages resourceStorages, RelativePath relativePath) {
        LogCssErrorHandler logCssErrorHandler = new LogCssErrorHandler();
        ElementMaps elementMaps = BdfServerUtils.parseCss(resourceStorages, relativePath, logCssErrorHandler);
        return OdsOptions.init().elementMaps(elementMaps).odLog(logCssErrorHandler);
    }

    public static Predicate<SubsetItem> toPredicate(BdfParameters bdfParameters, FichothequeQueries fichothequeQueries) {
        return BdfServerUtils.toPredicate(bdfParameters.getBdfServer(), bdfParameters.getPermissionSummary(), bdfParameters.getWorkingLang(), fichothequeQueries);
    }

    public static Predicate<SubsetItem> toPredicate(BdfServer bdfServer, PermissionSummary permissionSummary, Lang lang, FichothequeQueries fichothequeQueries) {
        List<FicheQuery> ficheQueryList = fichothequeQueries.getFicheQueryList();
        Predicate<FicheMeta> fichePredicate = null;
        if (!ficheQueryList.isEmpty()) {
            SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(bdfServer, lang).setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate()).toSelectionContext();
            FicheSelectorBuilder ficheSelectorBuilder = FicheSelectorBuilder.init(selectionContext);
            for (FicheQuery ficheQuery : ficheQueryList) {
                ficheSelectorBuilder.add(ficheQuery);
            }
            fichePredicate = SelectionUtils.toPredicate(ficheSelectorBuilder.toFicheSelector());
        }
        List<MotcleQuery> motcleQueryList = fichothequeQueries.getMotcleQueryList();
        Predicate<Motcle> motclePredicate = null;
        if (!motcleQueryList.isEmpty()) {
            SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(bdfServer, lang).setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate()).setFichePredicate(fichePredicate).toSelectionContext();
            MotcleSelectorBuilder motcleSelectorBuilder = MotcleSelectorBuilder.init(selectionContext);
            for (MotcleQuery motcleQuery : motcleQueryList) {
                motcleSelectorBuilder.add(motcleQuery, null);
            }
            motclePredicate = SelectionUtils.toPredicate(motcleSelectorBuilder.toMotcleSelector());
        }
        return EligibilityUtils.merge(fichePredicate, motclePredicate);
    }

    public static ElementMaps parseCss(BdfServer bdfServer, PathConfiguration pathConfiguration, String absoluteUri, CssErrorHandler cssErrorHandler) {
        CssSource cssSource = BdfURI.resolveCssSource(bdfServer, pathConfiguration, absoluteUri, null);
        if (cssSource == null) {
            cssErrorHandler.unknownURIFatalError(absoluteUri);
            return null;
        }
        try {
            return CssParser.parse(cssSource, cssErrorHandler);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static ElementMaps parseCss(ResourceStorages resourceStorages, RelativePath relativePath, CssErrorHandler cssErrorHandler) {
        CssSource cssSource = BdfURI.resolveCssSource(resourceStorages, relativePath);
        if (cssSource == null) {
            cssErrorHandler.unknownURIFatalError(relativePath.getPath());
            return null;
        }
        try {
            return CssParser.parse(cssSource, cssErrorHandler);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static List<MenuGroup> getExtensionMenuGroupList(BdfServer bdfServer, BdfUser bdfUser, Object menuObject) {
        ExtensionManager extensionManager = bdfServer.getExtensionManager();
        ArrayList<MenuGroup> menuGroupList = new ArrayList<MenuGroup>();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            MenuGroup[] array;
            MenuLinkProvider menuLinkProvider = (MenuLinkProvider)extensionReference.getImplementation(MenuLinkProvider.class);
            if (menuLinkProvider == null || (array = menuLinkProvider.getMenuGroupArray(bdfServer, bdfUser, menuObject)) == null) continue;
            for (MenuGroup menuGroup : array) {
                menuGroupList.add(menuGroup);
            }
        }
        return menuGroupList;
    }

    public static List<ActionGroup> getExtensionActionGroupList(String actionKey, BdfServer bdfServer, BdfUser bdfUser) {
        ExtensionManager extensionManager = bdfServer.getExtensionManager();
        ArrayList<ActionGroup> actionGroupList = new ArrayList<ActionGroup>();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            ActionGroup actionGroup;
            ActionProvider actionProvider = (ActionProvider)extensionReference.getImplementation(ActionProvider.class);
            if (actionProvider == null || (actionGroup = actionProvider.getActionGroup(actionKey, bdfServer, bdfUser)) == null) continue;
            actionGroupList.add(actionGroup);
        }
        return actionGroupList;
    }

    public static BdfCommand getExtensionBdfCommand(BdfCommandParameters bdfCommandParameters) {
        ExtensionManager extensionManager = bdfCommandParameters.getBdfServer().getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            BdfCommand bdfCommand;
            BdfCommandProvider bdfCommandProvider = (BdfCommandProvider)extensionReference.getImplementation(BdfCommandProvider.class);
            if (bdfCommandProvider == null || (bdfCommand = bdfCommandProvider.getBdfCommand(bdfCommandParameters)) == null) continue;
            return bdfCommand;
        }
        return null;
    }

    public static HtmlProducer getExtensionHtmlProducer(OutputParameters outputParameters) throws ErrorMessageException {
        ExtensionManager extensionManager = outputParameters.getBdfServer().getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            HtmlProducer htmlProducer;
            HtmlProducerProvider htmlProducerProvider = (HtmlProducerProvider)extensionReference.getImplementation(HtmlProducerProvider.class);
            if (htmlProducerProvider == null || (htmlProducer = htmlProducerProvider.getHtmlProducer(outputParameters)) == null) continue;
            return htmlProducer;
        }
        return null;
    }

    public static JsonProducer getExtensionJsonProducer(OutputParameters outputParameters) throws ErrorMessageException {
        ExtensionManager extensionManager = outputParameters.getBdfServer().getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            JsonProducer jsonProducer;
            JsonProducerProvider jsonProducerProvider = (JsonProducerProvider)extensionReference.getImplementation(JsonProducerProvider.class);
            if (jsonProducerProvider == null || (jsonProducer = jsonProducerProvider.getJsonProducer(outputParameters)) == null) continue;
            return jsonProducer;
        }
        return null;
    }

    public static StreamProducer getExtensionStreamProducer(OutputParameters outputParameters) throws ErrorMessageException {
        ExtensionManager extensionManager = outputParameters.getBdfServer().getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            StreamProducer streamProducer;
            StreamProducerProvider streamProducerProvider = (StreamProducerProvider)extensionReference.getImplementation(StreamProducerProvider.class);
            if (streamProducerProvider == null || (streamProducer = streamProducerProvider.getStreamProducer(outputParameters)) == null) continue;
            return streamProducer;
        }
        return null;
    }

    public static HookHandler getHookHandler(BdfServer bdfServer, BdfUser bdfUser, String hookHandlerName) {
        MultiHookHandlerBuilder builder = new MultiHookHandlerBuilder();
        ExtensionManager extensionManager = bdfServer.getExtensionManager();
        for (BdfExtensionReference extensionReference : extensionManager.getBdfExtensionReferenceList()) {
            HookHandler hookHandler;
            HookHandlerProvider hookHandlerProvider = (HookHandlerProvider)extensionReference.getImplementation(HookHandlerProvider.class);
            if (hookHandlerProvider == null || (hookHandler = hookHandlerProvider.getHookHandler(bdfServer, bdfUser, hookHandlerName)) == null) continue;
            builder.addHookHandler(hookHandler);
        }
        if (builder.isEmpty()) {
            return null;
        }
        return builder.toHookHandler();
    }

    public static LangContext checkLangContext(BdfServer bdfServer, @Nullable TableExportDef tableExportDef, @Nullable BdfUser bdfUser) {
        LangContext langContext = null;
        if (tableExportDef != null) {
            langContext = BdfServerUtils.checkLangMode(bdfServer, tableExportDef);
        }
        if (langContext == null) {
            langContext = bdfUser != null ? bdfUser : bdfServer.getLangConfiguration().toLangContext();
        }
        return langContext;
    }

    public static List<String> toActiveExtensionList(Collection<BdfExtensionReference> references) {
        ArrayList<String> activeExtensionList = new ArrayList<String>();
        for (BdfExtensionReference reference : references) {
            if (!reference.isActive()) continue;
            activeExtensionList.add(reference.getRegistrationName());
        }
        return activeExtensionList;
    }

    public static void checkResourceChange(BdfServer bdfServer, RelativePath relativePath) {
        String extension;
        switch (extension = FileName.getExtension(relativePath.getLastName())) {
            case "ini": {
                bdfServer.getL10nManager().update();
                break;
            }
            case "xsl": {
                bdfServer.getTransformationManager().update();
            }
        }
        bdfServer.getJsAnalyser().clearCache();
    }

    public static SelectionContextBuilder initSelectionContextBuilder(BdfParameters bdfParameters) {
        return BdfServerUtils.initSelectionContextBuilder(bdfParameters.getBdfServer(), bdfParameters.getWorkingLang());
    }

    public static SelectionContextBuilder initSelectionContextBuilder(BdfServer bdfServer, Lang workingLang) {
        return SelectionContextBuilder.init(bdfServer.getFichotheque(), bdfServer.getL10nManager(), workingLang);
    }

    public static ExtractionContextBuilder initAdminExtractionContextBuilder(BdfServer bdfServer) {
        return BdfServerUtils.initExtractionContextBuilder(bdfServer, LocalisationUtils.toUserLangContext(bdfServer.getDefaultWorkingLang()), PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY);
    }

    public static ExtractionContextBuilder initExtractionContextBuilder(BdfServer bdfServer, LangContext langContext, PermissionSummary permissionSummary) {
        return ExtractionContextBuilder.init(bdfServer.getFichotheque(), bdfServer.getL10nManager(), langContext, permissionSummary).setMimeTypeResolver(bdfServer.getMimeTypeResolver()).setDataResolverProvider(BdfServerUtils.buildDataResolverProvider(bdfServer)).setPolicyProvider(bdfServer.getPolicyManager().getPolicyProvider());
    }

    public static DataResolverProvider buildDataResolverProvider(BdfServer bdfServer) {
        return new InternalDataResolverProvider(bdfServer);
    }

    public static LangContext checkLangMode(BdfServer bdfServer, TableExportDef tableExportDef) {
        String langMode = tableExportDef.getLangMode();
        if (langMode != null) {
            switch (langMode) {
                case "working": {
                    return bdfServer.getLangConfiguration().toLangContext(false);
                }
                case "supplementary": {
                    return bdfServer.getLangConfiguration().toLangContext(true);
                }
                case "custom": {
                    Langs langs = tableExportDef.getLangs();
                    if (langs.isEmpty()) break;
                    return ListLangContextBuilder.build(langs);
                }
            }
        }
        return null;
    }

    public static ExtractionContext checkLangMode(ExtractionContext extractionContext, BdfServer bdfServer, TableExportDef tableExportDef) {
        LangContext checkedLangContext;
        if (tableExportDef != null && (checkedLangContext = BdfServerUtils.checkLangMode(bdfServer, tableExportDef)) != null) {
            return ExtractionUtils.derive(extractionContext, checkedLangContext);
        }
        return extractionContext;
    }

    public static List<Corpus> getIncludeSatelliteList(Corpus mainCorpus) {
        List<Corpus> satelliteList;
        Attribute attribute = mainCorpus.getCorpusMetadata().getAttributes().getAttribute(FicheFormSpace.SATELLITES_KEY);
        if (attribute != null && !(satelliteList = mainCorpus.getSatelliteCorpusList()).isEmpty()) {
            HashMap<String, Corpus> availableMap = new HashMap<String, Corpus>();
            HashSet<String> addedSet = new HashSet<String>();
            for (Corpus satellite : satelliteList) {
                availableMap.put(satellite.getSubsetName(), satellite);
            }
            ArrayList<Corpus> includedSatelliteList = new ArrayList<Corpus>();
            for (String value : attribute) {
                if (addedSet.contains(value)) continue;
                Corpus satellite = (Corpus)availableMap.get(value);
                if (satellite != null) {
                    includedSatelliteList.add(satellite);
                }
                addedSet.add(value);
            }
            return includedSatelliteList;
        }
        return FichothequeUtils.EMPTY_CORPUSLIST;
    }

    public static FichothequeQueries resolveSelectionOptions(BdfServer bdfServer, SelectionOptions selectionOptions) {
        return BdfServerUtils.mergeFichothequeQueries(bdfServer, selectionOptions.getSelectionDefName(), selectionOptions.getCustomFichothequeQueries());
    }

    public static FichothequeQueries mergeFichothequeQueries(BdfServer bdfServer, String selectionDefName, FichothequeQueries customFichothequeQueries) {
        SelectionDef selectionDef = bdfServer.getSelectionManager().getSelectionDef(selectionDefName);
        if (selectionDef == null) {
            return customFichothequeQueries;
        }
        if (customFichothequeQueries.isEmpty()) {
            return selectionDef.getFichothequeQueries();
        }
        return FichothequeQueriesBuilder.init().addFichothequeQueries(selectionDef.getFichothequeQueries()).addFichothequeQueries(customFichothequeQueries).toFichothequeQueries();
    }

    public static HtmlConverter getCleanerHtmlConverter(HtmlCleaner htmlCleaner) {
        return new CleanerHtmlConverter(htmlCleaner);
    }

    private static class InternalOpportunity
    implements SatelliteOpportunities.Entry {
        private final Corpus corpus;
        private final FicheMeta ficheMeta;
        private final short availableActionCategory;

        private InternalOpportunity(Corpus corpus, short availableActionCategory) {
            this.corpus = corpus;
            this.availableActionCategory = availableActionCategory;
            this.ficheMeta = null;
        }

        private InternalOpportunity(FicheMeta ficheMeta, short availableActionCategory) {
            this.corpus = ficheMeta.getCorpus();
            this.availableActionCategory = availableActionCategory;
            this.ficheMeta = ficheMeta;
        }

        @Override
        public Corpus getSatelliteCorpus() {
            return this.corpus;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public short getAvailableActionCategory() {
            return this.availableActionCategory;
        }
    }

    private static class SatelliteOpportunitiesEntryList
    extends AbstractList<SatelliteOpportunities.Entry>
    implements RandomAccess {
        private final SatelliteOpportunities.Entry[] array;

        private SatelliteOpportunitiesEntryList(SatelliteOpportunities.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SatelliteOpportunities.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalSatelliteOpportunities
    implements SatelliteOpportunities {
        private final List<SatelliteOpportunities.Entry> opportunityList;
        private final boolean onlyReadAllowed;

        private InternalSatelliteOpportunities(List<SatelliteOpportunities.Entry> opportunityList, boolean onlyReadAllowed) {
            this.opportunityList = opportunityList;
            this.onlyReadAllowed = onlyReadAllowed;
        }

        @Override
        public List<SatelliteOpportunities.Entry> getEntryList() {
            return this.opportunityList;
        }

        @Override
        public boolean onlyReadAllowed() {
            return this.onlyReadAllowed;
        }
    }

    private static class InternalDataResolverProvider
    implements DataResolverProvider {
        private final BdfServer bdfServer;
        private final Map<DataKey, DataResolver> resolverMap = new HashMap<DataKey, DataResolver>();

        private InternalDataResolverProvider(BdfServer bdfServer) {
            this.bdfServer = bdfServer;
        }

        @Override
        public DataResolver getDataResolver(SubsetKey subsetKey, String name) {
            DataKey dataKey = new DataKey(subsetKey, name);
            DataResolver dataResolver = this.resolverMap.get(dataKey);
            if (dataResolver == null) {
                ExternalSourceDef externalSourceDef = this.getExternalSourceDef(dataKey);
                dataResolver = externalSourceDef != null ? this.buildDataResolver(dataKey, externalSourceDef) : ExtractionContextUtils.DEFAULT_DATARESOLVER;
                this.resolverMap.put(dataKey, dataResolver);
            }
            return dataResolver;
        }

        private DataResolver buildDataResolver(DataKey dataKey, ExternalSourceDef externalSourceDef) {
            String type = externalSourceDef.getType();
            int idx = type.indexOf(58);
            if (idx != -1) {
                String registrationName = type.substring(0, idx);
                ExtensionDataResolverProvider extensionDataResolverProvider = this.getExtensionDataResolverProvider(registrationName);
                if (extensionDataResolverProvider != null) {
                    type = type.substring(idx + 1);
                    return extensionDataResolverProvider.getDataResolver(dataKey, new ExtensionExternalSourceDef(type, externalSourceDef));
                }
                return new ErrorDataResolver(type, "Unknown extension or extension without dataResolverProvider: " + registrationName);
            }
            switch (type) {
                case "fiches": {
                    try {
                        return FichesDataResolver.build(this.bdfServer, externalSourceDef);
                    }
                    catch (ResolverErrorException ree) {
                        return new ErrorDataResolver(type, ree.getMessage());
                    }
                }
            }
            return new ErrorDataResolver(type, "Unknown type: " + type);
        }

        private ExtensionDataResolverProvider getExtensionDataResolverProvider(String registrationName) {
            BdfExtensionReference bdfExtensionReference = this.bdfServer.getExtensionManager().getBdfExtensionReference(registrationName);
            if (bdfExtensionReference != null) {
                return (ExtensionDataResolverProvider)bdfExtensionReference.getImplementation(ExtensionDataResolverProvider.class);
            }
            return null;
        }

        private ExternalSourceDef getExternalSourceDef(DataKey dataKey) {
            SubsetKey subsetKey = dataKey.getSubsetKey();
            if (!subsetKey.isCorpusSubset()) {
                return null;
            }
            Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(subsetKey);
            if (corpus == null) {
                return null;
            }
            DataUi dataUi = (DataUi)this.bdfServer.getUiManager().getMainUiComponents(corpus).getUiComponent(dataKey);
            if (dataUi == null) {
                return null;
            }
            return dataUi.getExternalSourceDef();
        }
    }

    private static class CleanerHtmlConverter
    implements HtmlConverter {
        private final HtmlCleaner htmlCleaner;

        private CleanerHtmlConverter(HtmlCleaner htmlCleaner) {
            this.htmlCleaner = htmlCleaner;
        }

        @Override
        public FicheBlocks convertHtml(String html) {
            return ConversionEngine.convertHtmlFragment(this.htmlCleaner.cleanHtml(html).toString());
        }
    }

    private static class DefaultHtmlConverter
    implements HtmlConverter {
        private DefaultHtmlConverter() {
        }

        @Override
        public FicheBlocks convertHtml(String html) {
            return ConversionEngine.convertHtmlFragment(html);
        }
    }

    private static class EmptySatelliteOpportunities
    implements SatelliteOpportunities {
        private final List<SatelliteOpportunities.Entry> entryList = Collections.emptyList();

        private EmptySatelliteOpportunities() {
        }

        @Override
        public List<SatelliteOpportunities.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public boolean onlyReadAllowed() {
            return true;
        }
    }

    private static class ExtensionExternalSourceDef
    implements ExternalSourceDef {
        private final String type;
        private final ExternalSourceDef externalSourceDef;

        private ExtensionExternalSourceDef(String type, ExternalSourceDef externalSourceDef) {
            this.type = type;
            this.externalSourceDef = externalSourceDef;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getParam(String parameterName) {
            return this.externalSourceDef.getParam(parameterName);
        }

        @Override
        public Set<String> getParamNameSet() {
            return this.externalSourceDef.getParamNameSet();
        }
    }
}

