/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import java.text.ParseException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadata;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.fichotheque.tools.dom.FichothequeDOMUtils;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlbumDOMReader {
    private final AlbumEditor albumEditor;
    private final AlbumMetadataEditor albumMetadataEditor;
    private final MessageHandler messageHandler;

    public AlbumDOMReader(AlbumEditor albumEditor, MessageHandler messageHandler) {
        this.albumEditor = albumEditor;
        this.albumMetadataEditor = albumEditor.getAlbumMetadataEditor();
        this.messageHandler = messageHandler;
    }

    public void fillAlbum(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagname = element.getTagName();
            if (tagname.equals("metadata")) {
                this.fillMetadata(element);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
    }

    private void fillMetadata(Element element_xml) {
        AlbumMetadata metadata = (AlbumMetadata)this.albumMetadataEditor.getMetadata();
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("intitule")) {
                FichothequeDOMUtils.readIntitule(el, this.albumMetadataEditor, this.messageHandler, "album");
                continue;
            }
            if (tagname.equals("album-dim")) {
                this.addAlbumDim(el);
                continue;
            }
            if (tagname.equals("dim-usage")) continue;
            if (tagname.equals("attr")) {
                AttributeUtils.readAttrElement(attributesBuilder, el, this.messageHandler, tagname);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
        this.albumEditor.getFichothequeEditor().putAttributes(metadata, attributesBuilder.toAttributes());
    }

    private void addAlbumDim(Element element_xml) {
        AlbumDim albumDim;
        String tagName = "album-dim";
        String name = element_xml.getAttribute("name");
        if (name.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, tagName, "name");
            return;
        }
        tagName = tagName + " name=\"" + name + "\"";
        String type = element_xml.getAttribute("type");
        if (type.isEmpty()) {
            DomMessages.emptyAttribute(this.messageHandler, tagName, "type");
            return;
        }
        try {
            type = AlbumUtils.checkDimType(type);
        }
        catch (IllegalArgumentException iae) {
            DomMessages.wrongAttributeValue(this.messageHandler, tagName, "type", type);
            return;
        }
        int width = 0;
        int height = 0;
        if (AlbumUtils.needWidth(type) && (width = this.getInt(element_xml, tagName, "width")) == -1) {
            return;
        }
        if (AlbumUtils.needHeight(type) && (height = this.getInt(element_xml, tagName, "height")) == -1) {
            return;
        }
        try {
            albumDim = this.albumMetadataEditor.createAlbumDim(name, type);
        }
        catch (ParseException | ExistingNameException e) {
            return;
        }
        this.albumMetadataEditor.setDim(albumDim, width, height);
    }

    private int getInt(Element element_xml, String tagName, String attributeName) {
        int result;
        String intString = element_xml.getAttribute(attributeName);
        if (intString.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, tagName, attributeName);
            return -1;
        }
        try {
            result = Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue(this.messageHandler, tagName, attributeName, intString);
            return -1;
        }
        if (result < 1) {
            DomMessages.wrongIntegerAttributeValue(this.messageHandler, tagName, attributeName, intString);
            return -1;
        }
        return result;
    }
}

