/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.FramesetHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.IframesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.jsonproducers.session.PingJsonProducer;
import fr.exemole.bdfserver.tools.BdfHrefProvider;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.mapeadores.util.request.OutputInfo;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;

public class SessionInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final RequestMap requestMap;

    public SessionInstruction(BdfServer bdfServer, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
    }

    @Override
    public short getBdfUserNeed() {
        if (this.requestMap.isTrue("bdf-exit")) {
            return 4;
        }
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        OutputInfo outputInfo = OutputInfo.buildFromRequest(this.requestMap);
        if (outputInfo.getType() == 2) {
            PingJsonProducer jsonProducer = PingJsonProducer.authentified(this.bdfServer, bdfUser);
            return JsonResponseHandler.build(jsonProducer, this.requestMap).giveAccess(this.requestMap);
        }
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        BdfHrefProvider bdfHrefProvider = MainHtmlUtils.getMainProvider(this.requestMap);
        BdfServerHtmlProducer htmlProducer = BdfUserUtils.isWithJavascript(bdfUser) ? new IframesHtmlProducer(bdfParameters, bdfHrefProvider) : new FramesetHtmlProducer(bdfParameters, bdfHrefProvider);
        return HtmlResponseHandler.init(htmlProducer);
    }
}

