/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.htmlproducers;

import fr.exemole.bdfserver.html.BdfHtmlProducer;
import fr.exemole.bdfserver.html.BdfJsLibAssembly;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.tools.storage.IconScanEngine;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangsUtils;

public abstract class MultiHtmlProducer
extends BdfHtmlProducer {
    protected final Multi multi;
    protected final Lang workingLang;

    public MultiHtmlProducer(Multi multi) {
        this(multi.getAdminLang(), multi);
        this.addMessageLocalisation(multi.getAdminMessageLocalisation());
        this.setBodyCssClass("global-body-Default");
    }

    public MultiHtmlProducer(Multi multi, Lang lang) {
        this(lang, multi);
        this.addMessageLocalisation(multi.getMessageLocalisationProvider().getMessageLocalisation(lang));
    }

    public MultiHtmlProducer(Multi multi, LangPreference langPreference) {
        this(LangsUtils.getPreferredAvailableLang(multi.getMultiMetadata().getWorkingLangs(), langPreference), multi);
        this.addMessageLocalisation(multi.getMessageLocalisationProvider().getMessageLocalisation(langPreference));
    }

    private MultiHtmlProducer(Lang lang, Multi multi) {
        super(multi.getWebappsJsAnalyser(), multi.getBuildInfo());
        this.multi = multi;
        this.workingLang = lang;
        this.setWithJavascript(true);
        this.scanIcons();
        this.setReversePath("multi-rsc/");
    }

    @Override
    public void start(String title) {
        this.resolveJavascript();
        this.resolveCss();
        this.setIcons();
        super.start(this.workingLang, title);
    }

    @Override
    public void end() {
        BdfJsLibAssembly jsLibAssembly = this.getJsLibAssembly();
        if (jsLibAssembly != null) {
            jsLibAssembly.end(this, this.multi.getWebappsResourceStorages(), null, null, this.workingLang);
        }
        super.end();
    }

    private void scanIcons() {
        this.setSupplementaryIconAttributesList(IconScanEngine.run(this.multi.getWebappsResourceStorages(), this.multi.getMimeTypeResolver()));
    }

    public String getTitle(String defaultTitle) {
        return this.multi.getMultiMetadata().getTitleLabels().seekLabelString(this.workingLang, defaultTitle);
    }

    public JsObject getLangConfigurationObject() {
        return JsObject.init().put("workingLangArray", this.multi.getMultiMetadata().getWorkingLangs().toStringArray()).put("supplementaryLangArray", new String[0]);
    }
}

