/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.configuration.Target;
import java.io.File;
import java.io.IOException;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class ScrutariExportPathsJsonProperty
implements JsonProperty {
    private final ScrutariExportDef scrutariExportDef;
    private final PathConfiguration pathConfiguration;
    private final Target target;

    public ScrutariExportPathsJsonProperty(ScrutariExportDef scrutariExportDef, PathConfiguration pathConfiguration) {
        this.scrutariExportDef = scrutariExportDef;
        this.pathConfiguration = pathConfiguration;
        this.target = ConfigurationUtils.getTarget(pathConfiguration, scrutariExportDef);
    }

    @Override
    public String getName() {
        return "scrutariExportPaths";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.object();
        this.addObject(jw, "info", ".scrutari-info");
        this.addObject(jw, "data", ".scrutari-data");
        jw.endObject();
    }

    private void addObject(JSONWriter jw, String key, String suffix) throws IOException {
        String fileName = this.scrutariExportDef.getName() + suffix + ".xml";
        File destinationFile = new File(this.target.getFile(), fileName);
        String baseUrl = this.target.getUrl();
        jw.key(key);
        jw.object();
        jw.key("path").value(destinationFile.getAbsolutePath());
        jw.key("url");
        if (!baseUrl.isEmpty()) {
            jw.value(baseUrl + fileName);
        } else {
            jw.value("");
        }
        jw.endObject();
    }
}

