/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.managers.PasswordManager;
import fr.exemole.bdfserver.api.storage.PasswordStorage;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.security.PasswordChecker;

class PasswordManagerImpl
implements PasswordManager {
    private final Fichotheque fichotheque;
    private final PasswordStorage passwordStorage;

    PasswordManagerImpl(Fichotheque fichotheque, PasswordStorage passwordStorage) {
        this.fichotheque = fichotheque;
        this.passwordStorage = passwordStorage;
        this.check();
    }

    private void check() {
        Object[] passwordArray = this.passwordStorage.getPasswordArray();
        SortedMap<String, String> passwordMap = PasswordManagerImpl.toSortedMap((String[])passwordArray);
        int length = passwordArray.length;
        for (int i = 0; i < length; i += 2) {
            String checkedKey = this.testKey(passwordArray[i]);
            if (checkedKey == null) continue;
            passwordMap.put(checkedKey, (String)passwordArray[i + 1]);
        }
        Object[] newArray = PasswordManagerImpl.toPasswordArray(passwordMap);
        if (!Arrays.equals(passwordArray, newArray)) {
            this.passwordStorage.savePasswordArray((String[])newArray);
        }
    }

    @Override
    public boolean checkPassword(String passwordKey, String passwordValue) {
        String[] passwordArray = this.passwordStorage.getPasswordArray();
        int length = passwordArray.length;
        for (int i = 0; i < length; i += 2) {
            if (!passwordArray[i].equals(passwordKey)) continue;
            return PasswordChecker.check(passwordValue, passwordArray[i + 1]);
        }
        return false;
    }

    @Override
    public synchronized void setPassword(String passwordKey, String passwordValue) {
        SortedMap<String, String> map = PasswordManagerImpl.toSortedMap(this.passwordStorage.getPasswordArray());
        if (passwordValue == null || passwordValue.length() == 0) {
            map.remove(passwordKey);
        } else {
            map.put(passwordKey, PasswordChecker.getHash("pbkdf2", passwordValue));
        }
        this.passwordStorage.savePasswordArray(PasswordManagerImpl.toPasswordArray(map));
    }

    @Override
    public String getEncryptedPassword(String passwordKey) {
        String[] passwordArray = this.passwordStorage.getPasswordArray();
        int length = passwordArray.length;
        for (int i = 0; i < length; i += 2) {
            if (!passwordArray[i].equals(passwordKey)) continue;
            return passwordArray[i + 1];
        }
        return null;
    }

    @Override
    public synchronized void setEncryptedPassword(String passwordKey, String encryptedPasswordValue) {
        SortedMap<String, String> map = PasswordManagerImpl.toSortedMap(this.passwordStorage.getPasswordArray());
        if (encryptedPasswordValue == null || encryptedPasswordValue.length() == 0) {
            map.remove(passwordKey);
        } else {
            map.put(passwordKey, encryptedPasswordValue);
        }
        this.passwordStorage.savePasswordArray(PasswordManagerImpl.toPasswordArray(map));
    }

    @Override
    public String[] toPasswordArray() {
        return this.passwordStorage.getPasswordArray();
    }

    private String testKey(String key) {
        if (key.equals("confirm")) {
            return null;
        }
        try {
            Redacteur redacteur = SphereUtils.parse(this.fichotheque, key);
            return redacteur.getGlobalId();
        }
        catch (SphereUtils.RedacteurLoginException rle) {
            if (rle.getType() == 1) {
                return key;
            }
            return null;
        }
    }

    private static String[] toPasswordArray(Map<String, String> passwordMap) {
        int size = passwordMap.size();
        String[] array = new String[size * 2];
        int p = 0;
        for (Map.Entry<String, String> entry : passwordMap.entrySet()) {
            array[2 * p] = entry.getKey();
            array[2 * p + 1] = entry.getValue();
            ++p;
        }
        return array;
    }

    private static SortedMap<String, String> toSortedMap(String[] passwordArray) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        int length = passwordArray.length;
        for (int i = 0; i < length; i += 2) {
            map.put(passwordArray[i], passwordArray[i + 1]);
        }
        return map;
    }
}

