/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.externalscript.ExternalScript;
import fr.exemole.bdfserver.api.managers.ExternalScriptManager;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

class ExternalScriptManagerImpl
implements ExternalScriptManager {
    private static final Pattern SCRIPTNAME_PATTERN;
    private final BdfServer bdfServer;

    ExternalScriptManagerImpl(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    @Override
    public SortedSet<String> getScriptNameSet() {
        File scriptDirectory = this.bdfServer.getBdfServerDirs().getDir("etc.scripts");
        TreeSet<String> set = new TreeSet<String>();
        if (scriptDirectory.exists() && scriptDirectory.isDirectory()) {
            for (File file : scriptDirectory.listFiles()) {
                String name;
                if (file.isDirectory() || !SCRIPTNAME_PATTERN.matcher(name = file.getName()).matches()) continue;
                set.add(name);
            }
        }
        return set;
    }

    @Override
    public ExternalScript getExternalScript(String name) {
        File scriptDirectory = this.bdfServer.getBdfServerDirs().getDir("etc.scripts");
        if (!scriptDirectory.exists() || !scriptDirectory.isDirectory()) {
            return null;
        }
        PathConfiguration pathConfiguration = PathConfigurationBuilder.build(this.bdfServer);
        for (File file : scriptDirectory.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).equals(name)) continue;
            return new ImplExternalScript(this.bdfServer, name, file, pathConfiguration);
        }
        return null;
    }

    static {
        try {
            SCRIPTNAME_PATTERN = Pattern.compile("^[a-zA-Z][-_a-zA-Z0-9.]+$");
        }
        catch (PatternSyntaxException pse) {
            throw new ShouldNotOccurException(pse);
        }
    }

    private static class ImplExternalScript
    implements ExternalScript {
        private final BdfServer bdfServer;
        private final String name;
        private final File file;
        private final PathConfiguration pathConfiguration;

        private ImplExternalScript(BdfServer bdfServer, String name, File file, PathConfiguration pathConfiguration) {
            this.bdfServer = bdfServer;
            this.name = name;
            this.file = file;
            this.pathConfiguration = pathConfiguration;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Process exec() throws IOException {
            File resultFile = ConfigurationUtils.getScriptResultLogFile(this.bdfServer, this.name);
            File errorFile = ConfigurationUtils.getScriptErrorLogFile(this.bdfServer, this.name);
            ProcessBuilder processBuilder = new ProcessBuilder(this.file.getPath());
            processBuilder.redirectError(errorFile).redirectOutput(resultFile);
            Map<String, String> env = processBuilder.environment();
            for (String targetName : this.pathConfiguration.getTargetNameSet()) {
                File dir = this.pathConfiguration.getTargetDirectory(targetName);
                env.put("BDF_TARGET_" + targetName, dir.getCanonicalPath());
            }
            processBuilder.directory(this.file.getParentFile());
            return processBuilder.start();
        }
    }
}

