/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;

public class ThesaurusAdvancedCommandsHtmlProducer
extends BdfServerHtmlProducer {
    private final Thesaurus thesaurus;

    public ThesaurusAdvancedCommandsHtmlProducer(BdfParameters bdfParameters, Thesaurus thesaurus) {
        super(bdfParameters);
        this.thesaurus = thesaurus;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("thesaurus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.thesaurus, "thesaurus-advancedcommands");
        ThesaurusHtmlUtils.printThesaurusToolbar(this, "thesaurus-advancedcommands", this.thesaurus);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true);
        if (this.bdfParameters.isFichothequeAdmin() && this.thesaurus.isRemoveable()) {
            commandBox.errorPage("thesaurus-advancedcommands").page("_message");
            ThesaurusCommandBoxUtils.printThesaurusRemoveBox(this, commandBox, this.thesaurus);
        }
        commandBox.errorPage(null).page("thesaurus-advancedcommands");
        ThesaurusCommandBoxUtils.printThesaurusAttributeChangeBox(this, commandBox, this.thesaurus);
        if (this.thesaurus.isIdalphaType()) {
            ThesaurusCommandBoxUtils.printIdalphaSortBox(this, commandBox, this.thesaurus, null);
        }
        ThesaurusCommandBoxUtils.printChildrenReorderBox(this, commandBox, this.thesaurus, null);
        if (this.bdfParameters.isFichothequeAdmin()) {
            commandBox.page("thesaurus-metadataform").errorPage("thesaurus-advancedcommands");
            ThesaurusCommandBoxUtils.printThesaurusCloneBox(this, commandBox, this.thesaurus, this.workingLang);
        }
        ThesaurusCommandBoxUtils.printThesaurusCleaningBox(this, commandBox, this.thesaurus, this.workingLang);
        this.end();
    }
}

