/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import net.fichotheque.SubsetKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.localisation.Lang;

public class MotcleAdvancedCommandsHtmlProducer
extends BdfServerHtmlProducer {
    private final Thesaurus thesaurus;
    private final Motcle motcle;
    private final PermissionSummary permissionSummary;
    private final boolean withFontAwesome;

    public MotcleAdvancedCommandsHtmlProducer(BdfParameters bdfParameters, Motcle motcle) {
        super(bdfParameters);
        this.thesaurus = motcle.getThesaurus();
        this.motcle = motcle;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("thesaurus.css");
        this.withFontAwesome = this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, this.workingLang);
        this.start();
        ThesaurusHtmlUtils.printMotcleToolBar(this, this.bdfServer, this.bdfUser, this.motcle, "motcle-advancedcommands", thesaurusLang, this.withFontAwesome);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true).page("motcle-advancedcommands");
        if (this.thesaurus.isIdalphaType() && !this.motcle.getChildList().isEmpty()) {
            ThesaurusCommandBoxUtils.printIdalphaSortBox(this, commandBox, this.thesaurus, this.motcle);
        }
        if (!this.motcle.getChildList().isEmpty()) {
            ThesaurusCommandBoxUtils.printChildrenReorderBox(this, commandBox, this.thesaurus, this.motcle);
        }
        ThesaurusCommandBoxUtils.printMotcleAttributeChangeBox(this, commandBox, this.motcle);
        commandBox.page("motcle-changeform").errorPage("motcle-advancedcommands");
        SubsetTree originalSubsetTree = this.bdfServer.getTreeManager().getSubsetTree((short)2);
        SubsetTree adminSubsetTree = TreeFilterEngine.admin(this.permissionSummary, originalSubsetTree);
        ThesaurusCommandBoxUtils.printMotcleMoveBox(this, commandBox, this.motcle, this.bdfServer, this.workingLang, adminSubsetTree, (SubsetKey)this.bdfUser.getParameterValue("bdf.thesaurus.move_last"));
        SubsetTree readSubsetTree = TreeFilterEngine.read(this.permissionSummary, originalSubsetTree);
        ThesaurusCommandBoxUtils.printMotcleMergeBox(this, commandBox, this.motcle, this.bdfServer, this.workingLang, readSubsetTree, (SubsetKey)this.bdfUser.getParameterValue("bdf.thesaurus.merge_last"));
        this.end();
    }
}

