/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.mailing;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.SendReport;
import fr.exemole.bdfserver.email.TableExportEmail;
import fr.exemole.bdfserver.email.ValidAddress;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.CroisementSelection;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import fr.exemole.bdfserver.html.consumers.Tree;
import java.util.List;
import java.util.Set;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.SwitchException;

public class SendReportHtmlProducer
extends BdfServerHtmlProducer {
    private final EmailBuffer emailBuffer;
    private final SendReport sendReport;

    public SendReportHtmlProducer(BdfParameters bdfParameters, EmailBuffer emailBuffer, SendReport sendReport) {
        super(bdfParameters);
        this.emailBuffer = emailBuffer;
        this.sendReport = sendReport;
        this.addThemeCss("mailing.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(PageUnit.start("action-Send", "_ title.mailing.sendreport")).__(this.printCommandMessage()).__(this.printAttachmentList()).__(this.printFicheList()).__(this.printAddressList("to", "_ title.mailing.sendreport_to")).__(this.printAddressList("cc", "_ title.mailing.sendreport_cc")).__(this.printAddressList("bcc", "_ title.mailing.sendreport_bcc")).__(PageUnit.END);
        this.end();
    }

    private boolean printAttachmentList() {
        if (this.sendReport == null) {
            return false;
        }
        List<String> attachmentList = this.sendReport.getAttachmentList();
        if (attachmentList.isEmpty()) {
            return false;
        }
        this.H2().__localize("_ title.mailing.sendreport_attachments")._H2().__(Tree.TREE, () -> {
            for (String fileName : attachmentList) {
                this.__(Tree.LEAF, () -> this.__escape(fileName));
            }
        });
        return true;
    }

    private boolean printFicheList() {
        String sendType = this.emailBuffer.getSendType();
        this.H2().__localize(SendReportHtmlProducer.getTitleKey(sendType))._H2().__(this.printFiches(this.getFiches()));
        return true;
    }

    private boolean printFiches(Fiches fiches) {
        if (fiches.isEmpty()) {
            this.P().__localize("_ info.mailing.fiches_none")._P();
            return true;
        }
        this.UL("global-CroisementList");
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            this.LI().P().__(SubsetIcon.CORPUS).__escape(FichothequeUtils.getTitle(corpus, this.workingLang))._P().__(CroisementSelection.TREE, () -> {
                for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                    this.__(Tree.LEAF, () -> this.SPAN("mailing-Fiche").__escape(CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.formatLocale))._SPAN());
                }
            })._LI();
        }
        this._UL();
        return true;
    }

    private boolean printAddressList(String fieldName, String l10nKey) {
        boolean selfBcc = fieldName.equals("bcc") && this.emailBuffer.isWithRedacteurBcc();
        List<ValidAddress> list = this.emailBuffer.getValidAddressList(fieldName);
        if (list.isEmpty() && !selfBcc) {
            return false;
        }
        this.H2().__localize(l10nKey)._H2().__(Tree.TREE, () -> {
            for (ValidAddress validAddress : list) {
                this.__(Tree.LEAF, () -> this.__escape(validAddress.getEmailCore().toCompleteString(true)));
            }
            if (selfBcc) {
                this.__(Tree.LEAF, () -> this.__escape(this.emailBuffer.getRedacteurEmail().toCompleteString(true)));
            }
        });
        return true;
    }

    private Fiches getFiches() {
        Object sendObject = this.emailBuffer.getSendObject();
        switch (this.emailBuffer.getSendType()) {
            case "fiche": {
                return CorpusUtils.toSingletonFiches((FicheMeta)sendObject);
            }
            case "compilation": {
                return this.bdfUser.getSelectedFiches();
            }
            case "selection": {
                return FichesBuilder.init().addAll((Set)sendObject).toFiches();
            }
            case "tableexport": {
                return CorpusUtils.reduce(this.bdfUser.getSelectedFiches(), ((TableExportEmail)sendObject).getCorpus());
            }
        }
        throw new SwitchException("Unknown sendType: " + this.emailBuffer.getSendType());
    }

    private static String getTitleKey(String sendType) {
        switch (sendType) {
            case "fiche": {
                return "_ title.mailing.sendreport_fiches";
            }
            case "compilation": {
                return "_ title.mailing.sendreport_compilation";
            }
            case "selection": {
                return "_ title.mailing.sendreport_fiches";
            }
            case "tableexport": {
                return "_ title.mailing.sendreport_tableexport";
            }
        }
        throw new SwitchException("Unknown sendType: " + sendType);
    }
}

