/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.servlets.exceptions.InternalErrorException;

public class IllustrationStreamProducer
implements StreamProducer {
    private final String fileName;
    private final Illustration illustration;
    private final AlbumDim albumDim;
    private final short specialDim;

    public IllustrationStreamProducer(String fileName, Illustration illustration, AlbumDim albumDim) {
        this.fileName = fileName;
        this.illustration = illustration;
        this.albumDim = albumDim;
        this.specialDim = 0;
    }

    public IllustrationStreamProducer(String fileName, Illustration illustration, short specialDim) {
        this.fileName = fileName;
        this.illustration = illustration;
        this.albumDim = null;
        this.specialDim = specialDim;
    }

    @Override
    public String getMimeType() {
        return AlbumUtils.getMimeType(this.illustration.getFormatType());
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.albumDim != null ? this.illustration.getInputStream(this.albumDim) : this.illustration.getInputStream(this.specialDim);
        if (inputStream == null) {
            throw new InternalErrorException("_ error.exception.internalerror", "input stream is null (" + this.illustration.getFileName() + ")");
        }
        try (InputStream is = inputStream;){
            IOUtils.copy(is, outputStream);
        }
    }
}

