/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.RangeConditionBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.request.RequestMap;

public class UserSelectionByMotcleCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserSelectionByMotcle";
    private Motcle motcle;

    public UserSelectionByMotcleCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheQuery ficheQuery = this.toFicheQuery();
        this.bdfServer.getSelectionManager().setFicheSelection(this.bdfUser, ficheQuery, "id-asc");
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
    }

    private FicheQuery toFicheQuery() {
        MotcleQueryBuilder motcleQueryBuilder = new MotcleQueryBuilder();
        if (this.motcle.getThesaurus().isIdalphaType()) {
            String idalpha = this.motcle.getIdalpha();
            TextCondition condition = ConditionsUtils.parseCondition(idalpha, "and");
            motcleQueryBuilder.setContentCondition(condition, "idalpha_only");
        } else {
            Ranges ranges = new Ranges();
            ranges.addRange(new Range(this.motcle.getId(), this.motcle.getId()));
            motcleQueryBuilder.setIdRangeCondition(RangeConditionBuilder.init(ranges).toRangeCondition());
        }
        motcleQueryBuilder.addThesaurus(this.motcle.getThesaurus());
        return FicheQueryBuilder.init().addMotcleConditionEntry(SelectionUtils.toMotcleConditionEntry(motcleQueryBuilder.toMotcleQuery(), null, true)).toFicheQuery();
    }
}

