/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.CroisementRevision;
import net.fichotheque.croisement.Lien;
import net.fichotheque.history.CroisementHistory;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class FicheRestoreCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheRestore";
    private Corpus corpus;
    private int id;
    private FicheHistory ficheHistory;
    private HistoryUnit.Revision lastRevision;
    private String isoTime;

    public FicheRestoreCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheMeta ficheMeta;
        Fiche fiche = this.corpus.getFicheRevision(this.id, this.lastRevision.getName());
        List<CroisementBySubset> list = this.checkCroisements();
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            CorpusEditor corpusEditor = fichothequeEditor.getCorpusEditor(this.corpus);
            CroisementEditor croisementEditor = fichothequeEditor.getCroisementEditor();
            try {
                ficheMeta = corpusEditor.createFiche(this.id);
            }
            catch (ExistingIdException eii) {
                throw new ImplementationException(eii);
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException(nmie);
            }
            corpusEditor.setDate(ficheMeta, FuzzyDate.current(), true);
            corpusEditor.saveFiche(ficheMeta, fiche);
            for (CroisementBySubset croisemetBySubset : list) {
                croisemetBySubset.restoreCroisements(ficheMeta, croisementEditor);
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.putResultObject("obj.fichemeta", ficheMeta);
        this.setDone("_ done.corpus.ficheretrieve", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.id = this.requestHandler.getMandatoryId();
        if (this.corpus.getFicheMetaById(this.id) != null) {
            throw BdfErrors.error("_ error.existing.id", this.id);
        }
        this.ficheHistory = this.corpus.getFicheHistory(this.id);
        if (this.ficheHistory == null) {
            throw BdfErrors.error("_ error.unknown.history", this.id);
        }
        if (this.ficheHistory.getFicheUnit().isEmpty()) {
            throw BdfErrors.error("_ error.empty.history", this.id);
        }
        this.lastRevision = this.ficheHistory.getFicheUnit().getMostRecentRevision();
        this.isoTime = this.lastRevision.getEditOriginList().get(0).getISOTime();
    }

    private List<CroisementBySubset> checkCroisements() {
        ArrayList<CroisementBySubset> result = new ArrayList<CroisementBySubset>();
        for (Subset subset : this.fichotheque.getThesaurusList()) {
            this.addCroisementBySubset(result, subset);
        }
        for (Subset subset : this.fichotheque.getCorpusList()) {
            this.addCroisementBySubset(result, subset);
        }
        return result;
    }

    private void addCroisementBySubset(List<CroisementBySubset> list, Subset subset) {
        CroisementBySubset cbt = new CroisementBySubset(subset);
        List<CroisementHistory> croisementHistoryList = this.corpus.getCroisementHistoryList(this.id, subset.getSubsetKey());
        for (CroisementHistory croisementHistory : croisementHistoryList) {
            EditOrigin editOrigin;
            HistoryUnit croisementUnit = croisementHistory.getCroisementUnit();
            if (croisementUnit.isEmpty() || !(editOrigin = croisementUnit.getMostRecentEditOrigin()).getISOTime().equals(this.isoTime)) continue;
            cbt.add(croisementHistory.getCroisementKey(), croisementUnit.getMostRecentRevision().getName());
        }
        if (!cbt.isEmpty()) {
            list.add(cbt);
        }
    }

    private class CroisementBySubset {
        private final Subset subset;
        private final List<Couple> coupleList = new ArrayList<Couple>();

        private CroisementBySubset(Subset subset) {
            this.subset = subset;
        }

        private boolean isEmpty() {
            return this.coupleList.isEmpty();
        }

        private void add(CroisementKey croisementKey, String versionName) {
            this.coupleList.add(new Couple(croisementKey, versionName));
        }

        private void restoreCroisements(FicheMeta ficheMeta, CroisementEditor croisementEditor) {
            for (Couple couple : this.coupleList) {
                CroisementRevision croisementRevision;
                CroisementKey croisementKey = couple.croisementKey;
                String versionName = couple.versionName;
                SubsetItem otherSubsetItem = CroisementUtils.getOther(ficheMeta, croisementKey, this.subset);
                if (otherSubsetItem == null || (croisementRevision = FicheRestoreCommand.this.fichotheque.getCroisementRevision(croisementKey, versionName)) == null) continue;
                croisementEditor.updateCroisement(ficheMeta, otherSubsetItem, new RestoreCroisementChange(croisementRevision));
            }
        }
    }

    private static class RestoreCroisementChange
    implements CroisementChange {
        private final CroisementRevision croisementRevision;

        private RestoreCroisementChange(CroisementRevision croisementRevision) {
            this.croisementRevision = croisementRevision;
        }

        @Override
        public List<String> getRemovedModeList() {
            return StringUtils.EMPTY_STRINGLIST;
        }

        @Override
        public List<Lien> getChangedLienList() {
            return this.croisementRevision.getLienList();
        }
    }

    private static class Couple {
        private final CroisementKey croisementKey;
        private final String versionName;

        private Couple(CroisementKey croisementKey, String versionName) {
            this.croisementKey = croisementKey;
            this.versionName = versionName;
        }
    }
}

