/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.DataUiBuilder;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class DataCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DataCreationCommand";
    public static final String COMMANDKEY = "_ CRP-33";
    public static final String NAME_PARAMNAME = "name";
    public static final String TYPE_PARAMNAME = "type";
    private Corpus corpus;
    private UiComponents uiComponents;
    private String name;
    private String type;

    public DataCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().putComponentUi(this.uiComponents, DataUiBuilder.init(this.name, this.type).toDataUi());
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.datacreation", this.name);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.name = this.getMandatory(NAME_PARAMNAME);
        this.type = this.getMandatory(TYPE_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        String componentName = DataUi.toComponentName(this.name);
        if (this.uiComponents.contains(componentName)) {
            throw BdfErrors.error("_ error.existing.include", componentName);
        }
        try {
            DataUi.checkDataName(this.name);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.dataname", this.name);
        }
    }
}

