/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumDimCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumDimCreation";
    public static final String COMMANDKEY = "_ ALB-03";
    public static final String NEWALBUMDIM_PARAMNAME = "newalbumdim";
    public static final String ALBUMDIMTYPE_PARAMNAME = "albumdimtype";
    private Album album;
    private String newAlbumDimName;
    private String albumDimType;

    public AlbumDimCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        AlbumDim albumDim;
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            AlbumEditor albumEditor = session.getFichothequeEditor().getAlbumEditor(this.album);
            try {
                albumDim = albumEditor.getAlbumMetadataEditor().createAlbumDim(this.newAlbumDimName, this.albumDimType);
            }
            catch (ParseException | ExistingNameException e) {
                throw new ShouldNotOccurException("test done before", e);
            }
        }
        this.putResultObject("obj.album", this.album);
        this.putResultObject("obj.albumdim", albumDim);
        this.setDone("_ done.album.albumdimcreation", this.newAlbumDimName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.album = this.requestHandler.getMandatoryAlbum();
        this.checkSubsetAdmin(this.album);
        this.newAlbumDimName = this.getMandatory(NEWALBUMDIM_PARAMNAME).trim();
        if (this.newAlbumDimName.isEmpty()) {
            throw BdfErrors.error("_ error.empty.albumdimname");
        }
        if (this.album.getAlbumMetadata().getAlbumDimByName(this.newAlbumDimName) != null) {
            throw BdfErrors.error("_ error.existing.albumdim", this.newAlbumDimName);
        }
        if (!AlbumUtils.isValidAlbumDimName(this.newAlbumDimName)) {
            throw BdfErrors.error("_ error.wrong.albumdimname", this.newAlbumDimName);
        }
        String albumDimTypeValue = this.getMandatory(ALBUMDIMTYPE_PARAMNAME);
        try {
            this.albumDimType = AlbumUtils.checkDimType(albumDimTypeValue);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(ALBUMDIMTYPE_PARAMNAME, albumDimTypeValue);
        }
    }
}

